/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/l11n/")
public class LocalizationConnector
implements ResourceContainer {
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    @GET
    @Path(value="/cleanName/")
    public Response getCleanName(@QueryParam(value="name") String name) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        try {
            return Response.ok((Object)Utils.cleanString((String)name)).header(CONTENT_TYPE, (Object)"text/html; charset=utf-8").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            return Response.ok().header(CONTENT_TYPE, (Object)"text/html; charset=utf-8").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
    }

    @GET
    @Path(value="/convertName/")
    public Response convertName(@QueryParam(value="name") String name) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        try {
            return Response.ok((Object)Text.convertJcrChars((String)name)).header(CONTENT_TYPE, (Object)"text/html; charset=utf-8").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            return Response.ok().header(CONTENT_TYPE, (Object)"text/html; charset=utf-8").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
    }
}

