/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.GraphServiceException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.UploadSession;

public class ChunkedUploadResult<UploadType> {
    private final UploadType uploadedItem;
    private final UploadSession session;
    private final ClientException error;

    public ChunkedUploadResult(UploadType uploaded) {
        this.uploadedItem = uploaded;
        this.session = null;
        this.error = null;
    }

    public ChunkedUploadResult(UploadSession session) {
        this.session = session;
        this.uploadedItem = null;
        this.error = null;
    }

    public ChunkedUploadResult(ClientException error) {
        this.error = error;
        this.uploadedItem = null;
        this.session = null;
    }

    public ChunkedUploadResult(GraphServiceException exception) {
        this(new ClientException(exception.getMessage(true), exception));
    }

    public boolean chunkCompleted() {
        return this.uploadedItem != null || this.session != null;
    }

    public boolean uploadCompleted() {
        return this.uploadedItem != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public UploadType getItem() {
        return this.uploadedItem;
    }

    public UploadSession getSession() {
        return this.session;
    }

    public ClientException getError() {
        return this.error;
    }
}

