/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.unlock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.comparator.NodeOwnerComparator;
import org.exoplatform.ecm.webui.comparator.NodeTitleComparator;
import org.exoplatform.ecm.webui.component.admin.unlock.UILockHolderContainer;
import org.exoplatform.ecm.webui.component.admin.unlock.UILockedNodePageList;
import org.exoplatform.ecm.webui.component.admin.unlock.UIUnLockManager;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/unlock/UILockNodeList.gtmpl", events={@EventConfig(listeners={UnLockActionListener.class}), @EventConfig(listeners={SortActionListener.class})})
public class UILockNodeList
extends UIPagingGridDecorator {
    public static final String[] ACTIONS = new String[0];
    public static final String ST_EDIT = "EditUnLockForm";
    private Preference preferences_;
    private static final String LOCK_QUERY = "select * from mix:lockable where jcr:lockOwner IS NOT NULL order by exo:dateCreated DESC";
    private String typeSort_ = "Type";
    private String sortOrder_ = "Up";
    private String order_ = "Ascending";
    public static final String SORT_BY_NODENAME = "Alphabetic";
    public static final String SORT_BY_NODEOWNER = "Owner";

    public String getTypeSort() {
        return this.typeSort_;
    }

    public void setTypeSort(String typeSort) {
        this.typeSort_ = typeSort;
    }

    public String getSortOrder() {
        return this.sortOrder_;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder_ = sortOrder;
    }

    public String getOrder() {
        return this.order_;
    }

    public void setOrder(String order) {
        this.order_ = order;
    }

    public void setPreferences(Preference preference) {
        this.preferences_ = preference;
    }

    public UILockNodeList() throws Exception {
        this.getUIPageIterator().setId("LockNodeListIterator");
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(int currentPage) throws Exception {
        if (!this.getUIPageIterator().isJustPaginated()) {
            UILockedNodePageList pageList = new UILockedNodePageList(LOCK_QUERY, this.getUIPageIterator().getItemsPerPage(), currentPage);
            this.getUIPageIterator().setPageList((PageList)pageList);
        }
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
        this.getUIPageIterator().setJustPaginated(false);
    }

    public List getLockedNodeList() throws Exception {
        return this.sort(NodeLocation.getNodeListByLocationList((List)this.getUIPageIterator().getCurrentPageData()));
    }

    public List<Node> getAllLockedNodes() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageRepository = repositoryService.getCurrentRepository();
        RepositoryEntry repo = manageRepository.getConfiguration();
        ArrayList<Node> listLockedNodes = new ArrayList<Node>();
        QueryManager queryManager = null;
        Session session = null;
        String queryStatement = LOCK_QUERY;
        Query query = null;
        QueryResult queryResult = null;
        for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
            session = WCMCoreUtils.getSystemSessionProvider().getSession(ws.getName(), manageRepository);
            queryManager = session.getWorkspace().getQueryManager();
            query = queryManager.createQuery(queryStatement, "sql");
            queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node itemNode = iter.nextNode();
                if (Utils.isInTrash((Node)itemNode) || !itemNode.isLocked()) continue;
                listLockedNodes.add(itemNode);
            }
        }
        return listLockedNodes;
    }

    private List<Node> sort(List<Node> childrenList) {
        if (SORT_BY_NODENAME.equals(this.getTypeSort())) {
            Collections.sort(childrenList, new NodeTitleComparator(this.getOrder()));
        } else if (SORT_BY_NODEOWNER.equals(this.getTypeSort())) {
            Collections.sort(childrenList, new NodeOwnerComparator(this.getOrder()));
        }
        return childrenList;
    }

    public static class UnLockActionListener
    extends EventListener<UILockNodeList> {
        private List<String> getCurrentUserMemberships() throws Exception {
            ArrayList<String> groupList = new ArrayList<String>();
            Collection memberships = ConversationState.getCurrent().getIdentity().getMemberships();
            for (MembershipEntry entry : memberships) {
                groupList.add(entry.getMembershipType() + ":" + entry.getGroup());
            }
            return groupList;
        }

        public void execute(Event<UILockNodeList> event) throws Exception {
            WebuiRequestContext rContext = event.getRequestContext();
            UIUnLockManager uiUnLockManager = (UIUnLockManager)((UILockNodeList)((Object)event.getSource())).getParent();
            UIApplication uiApp = (UIApplication)uiUnLockManager.getAncestorOfType(UIApplication.class);
            String nodePath = rContext.getRequestParameter("objectId");
            RepositoryService repositoryService = (RepositoryService)uiUnLockManager.getApplicationComponent(RepositoryService.class);
            ManageableRepository manageRepository = repositoryService.getCurrentRepository();
            Session session = null;
            Node lockedNode = null;
            UserACL userACLService = (UserACL)WCMCoreUtils.getService(UserACL.class);
            String remoteUser = rContext.getRemoteUser();
            boolean isAuthenticated = remoteUser.equals(userACLService.getSuperUser());
            if (!isAuthenticated) {
                LockService lockService = (LockService)WCMCoreUtils.getService(LockService.class);
                List authorizedMemberships = lockService.getAllGroupsOrUsersForLock();
                List<String> loginedUserMemberShips = this.getCurrentUserMemberships();
                Set loginedUserGroups = ConversationState.getCurrent().getIdentity().getGroups();
                Iterator iterator = authorizedMemberships.iterator();
                while (iterator.hasNext()) {
                    String authorizedMembership = (String)iterator.next();
                    if ((!authorizedMembership.startsWith("*") || !loginedUserGroups.contains(StringUtils.substringAfter((String)authorizedMembership, (String)":"))) && !loginedUserMemberShips.contains(authorizedMembership)) continue;
                    isAuthenticated = true;
                    break;
                }
            }
            RepositoryEntry repo = repositoryService.getCurrentRepository().getConfiguration();
            for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                session = isAuthenticated ? WCMCoreUtils.getSystemSessionProvider().getSession(ws.getName(), manageRepository) : WCMCoreUtils.getSystemSessionProvider().getSession(ws.getName(), manageRepository);
                try {
                    lockedNode = (Node)session.getItem(nodePath);
                    if (lockedNode == null || Utils.isInTrash((Node)lockedNode)) continue;
                    break;
                }
                catch (PathNotFoundException e) {
                }
                catch (AccessDeniedException accessDeniedException) {
                }
            }
            if (lockedNode == null) {
                Object[] args = new Object[]{nodePath};
                ApplicationMessage msg = new ApplicationMessage("UILockNodeList.msg.access-denied-exception", args, 1);
                msg.setArgsLocalized(false);
                uiApp.addMessage(msg);
                uiUnLockManager.refresh();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
                return;
            }
            if (isAuthenticated) {
                session = WCMCoreUtils.getSystemSessionProvider().getSession(lockedNode.getSession().getWorkspace().getName(), (ManageableRepository)lockedNode.getSession().getRepository());
                lockedNode = (Node)session.getItem(lockedNode.getPath());
            }
            try {
                if (lockedNode.holdsLock()) {
                    String lockToken = LockUtil.getLockToken(lockedNode);
                    if (lockToken != null) {
                        session.addLockToken(lockToken);
                    }
                    lockedNode.unlock();
                    lockedNode.removeMixin("mix:lockable");
                    lockedNode.getSession().save();
                    LockUtil.removeLock((Node)lockedNode);
                }
            }
            catch (LockException le) {
                uiApp.addMessage(new ApplicationMessage("UILockNodeList.msg.can-not-unlock-node", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
                return;
            }
            catch (VersionException versionException) {
                Object[] args = new Object[]{lockedNode.getName()};
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-unlock-node-is-checked-in", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            uiUnLockManager.refresh();
            ((UILockNodeList)uiUnLockManager.getChild(UILockNodeList.class)).setRendered(true);
            ((UILockHolderContainer)uiUnLockManager.getChild(UILockHolderContainer.class)).setRendered(false);
        }
    }

    public static class SortActionListener
    extends EventListener<UILockNodeList> {
        public void execute(Event<UILockNodeList> event) throws Exception {
            UILockNodeList uicomp = (UILockNodeList)((Object)event.getSource());
            UIUnLockManager uiUnLockManager = (UIUnLockManager)((UILockNodeList)((Object)event.getSource())).getParent();
            UIApplication uiApp = (UIApplication)uiUnLockManager.getAncestorOfType(UIApplication.class);
            try {
                String sortParam = event.getRequestContext().getRequestParameter("objectId");
                String[] array = sortParam.split(";");
                String order = "Ascending".equals(array[0].trim()) || !array[1].trim().equals(uicomp.getTypeSort()) ? "Down" : "Up";
                String prefOrder = "Ascending".equals(array[0].trim()) || !array[1].trim().equals(uicomp.getTypeSort()) ? "Ascending" : "Descending";
                uicomp.setSortOrder(order);
                uicomp.setTypeSort(array[1]);
                uicomp.setOrder(prefOrder);
                uiUnLockManager.refresh();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUnLockManager);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }
}

