/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util.content;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.OContentParser;

public class ContentParserFactory {
    private static final Logger logger = Logger.getLogger(ContentParserFactory.class.toString());
    private static ContentParserFactory contentParserFactory;
    private static final String N_CONTENT_PARSER = "org.icepdf.core.util.content.NContentParser";
    private static boolean foundPro;

    private ContentParserFactory() {
    }

    public static ContentParserFactory getInstance() {
        if (contentParserFactory == null) {
            contentParserFactory = new ContentParserFactory();
        }
        return contentParserFactory;
    }

    public ContentParser getContentParser(Library library, Resources resources) {
        if (foundPro) {
            try {
                Class<?> contentParserClass = Class.forName(N_CONTENT_PARSER);
                Class[] parserArgs = new Class[]{Library.class, Resources.class};
                Constructor<?> fontClassConstructor = contentParserClass.getDeclaredConstructor(parserArgs);
                Object[] args = new Object[]{library, resources};
                return (ContentParser)fontClassConstructor.newInstance(args);
            }
            catch (Throwable e) {
                logger.log(Level.FINE, "Could not load font dictionary class", e);
            }
        }
        return new OContentParser(library, resources);
    }

    static {
        try {
            Class.forName(N_CONTENT_PARSER);
            foundPro = true;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "ICEpdf PRO was not found on the class path");
        }
    }
}

