/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.platform;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.NotYetCloudFileException;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.connector.FileUploadHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/managedocument/")
public class ManageDocumentService
implements ResourceContainer {
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private final CacheControl cc;
    private static final Log LOG = ExoLogger.getLogger((String)ManageDocumentService.class.getName());
    private static final String DEFAULT_NAME = "untitled";
    private final ManageDriveService manageDriveService;
    private final LinkManager linkManager;
    private final CloudDriveService cloudDrives;
    protected FileUploadHandler fileUploadHandler;
    public static final String EXO_MUSICFOLDER = "exo:musicFolder";
    public static final String EXO_VIDEOFOLDER = "exo:videoFolder";
    public static final String EXO_PICTUREFOLDER = "exo:pictureFolder";
    public static final String EXO_DOCUMENTFOLDER = "exo:documentFolder";
    public static final String EXO_SEARCHFOLDER = "exo:searchFolder";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String EXO_PRIMARYTYPE = "exo:primaryType";
    public static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    public static final String EXO_FAVOURITE_FOLDER = "exo:favoriteFolder";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FOLDER = "nt:folder";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};
    private static final String PRIVATE = "Private";
    private int limit;

    public ManageDocumentService(ManageDriveService manageDriveService, LinkManager linkManager, CloudDriveService cloudDrives, InitParams params) {
        this.manageDriveService = manageDriveService;
        this.linkManager = linkManager;
        this.cloudDrives = cloudDrives;
        this.fileUploadHandler = new FileUploadHandler();
        this.cc = new CacheControl();
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
        this.limit = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
    }

    @GET
    @Path(value="/getDrives/")
    @RolesAllowed(value={"users"})
    public Response getDrives(@QueryParam(value="driveType") String driveType, @DefaultValue(value="false") @QueryParam(value="showPrivate") String showPrivate, @DefaultValue(value="false") @QueryParam(value="showPersonal") String showPersonal) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        List<String> userRoles = this.getMemberships();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement("Folders");
        document.appendChild(rootElement);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        List driveList = new ArrayList();
        if (DriveType.GENERAL.toString().equalsIgnoreCase(driveType)) {
            driveList = this.manageDriveService.getMainDrives(userId, userRoles);
        } else if (DriveType.GROUP.toString().equalsIgnoreCase(driveType)) {
            driveList = this.manageDriveService.getGroupDrives(userId, userRoles);
        } else if (DriveType.PERSONAL.toString().equalsIgnoreCase(driveType)) {
            driveList = this.manageDriveService.getPersonalDrives(userId);
            String privateDrivePath = "";
            for (DriveData driveData : driveList) {
                if (!PRIVATE.equals(driveData.getName())) continue;
                privateDrivePath = driveData.getHomePath();
                if (Boolean.valueOf(showPrivate).booleanValue()) continue;
                driveList.remove(driveData);
                break;
            }
            if (!Boolean.valueOf(showPersonal).booleanValue()) {
                for (DriveData driveData : driveList) {
                    if (!privateDrivePath.equals(driveData.getHomePath())) continue;
                    driveList.remove(driveData);
                    break;
                }
            }
        }
        rootElement.appendChild(this.buildXMLDriveNodes(document, driveList, driveType));
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(this.cc).build();
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    @RolesAllowed(value={"users"})
    public Response getFoldersAndFiles(@QueryParam(value="driveName") String driveName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="currentFolder") String currentFolder, @DefaultValue(value="false") @QueryParam(value="showHidden") String showHidden) {
        try {
            Node node = this.getNode(driveName, workspaceName, currentFolder);
            return this.buildXMLResponseForChildren(node, driveName, currentFolder, Boolean.valueOf(showHidden));
        }
        catch (AccessDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Access is denied when perform get Folders and files: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Item is not found: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Repository is error: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when perform get Folders and files: ", (Throwable)e);
            }
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/deleteFolderOrFile/")
    @RolesAllowed(value={"users"})
    public Response deleteFolderOrFile(@QueryParam(value="driveName") String driveName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="itemPath") String itemPath) {
        try {
            Node node = this.getNode(driveName, workspaceName, itemPath);
            Node parent = node.getParent();
            node.remove();
            parent.save();
            return Response.ok().cacheControl(this.cc).build();
        }
        catch (AccessDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Access is denied when perform delete folder or file: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Item is not found: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Repository is error: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when perform delete Folder or file: ", (Throwable)e);
            }
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/createFolder/")
    @RolesAllowed(value={"users"})
    public Response createFolder(@QueryParam(value="driveName") String driveName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="folderName") String folderName, @QueryParam(value="folderNodeType") @DefaultValue(value="nt:folder") String folderNodeType) throws Exception {
        try {
            Node node = this.getNode(driveName, workspaceName, currentFolder);
            String name = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)folderName));
            name = StringUtils.isEmpty((String)name) ? DEFAULT_NAME : name;
            Node newNode = node.addNode(name, folderNodeType);
            if (!newNode.hasProperty("exo:title")) {
                newNode.addMixin("exo:rss-enable");
            }
            newNode.setProperty("exo:title", folderName);
            node.save();
            Document document = this.createNewDocument();
            String childFolder = StringUtils.isEmpty((String)currentFolder) ? newNode.getName() : currentFolder.concat("/").concat(newNode.getName());
            Element folderNode = this.createFolderElement(document, newNode, workspaceName, driveName, childFolder);
            document.appendChild(folderNode);
            return this.getResponse(document);
        }
        catch (AccessDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Access is denied when perform create folder: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Item is not found: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Repository is error: ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when perform create folder: ", (Throwable)e);
            }
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="/uploadFile/upload/")
    @RolesAllowed(value={"users"})
    public Response uploadFile(@Context HttpServletRequest servletRequest, @QueryParam(value="uploadId") String uploadId) throws Exception {
        return this.fileUploadHandler.upload(servletRequest, uploadId, this.limit);
    }

    @GET
    @Path(value="/uploadFile/control/")
    @RolesAllowed(value={"users"})
    public Response processUpload(@QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="driveName") String driveName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="action") String action, @QueryParam(value="language") String language, @QueryParam(value="fileName") String fileName, @QueryParam(value="uploadId") String uploadId, @QueryParam(value="existenceAction") String existenceAction) throws Exception {
        block3: {
            try {
                if (workspaceName != null && driveName != null && currentFolder != null) {
                    Node currentFolderNode = this.getNode(Text.escapeIllegalJcrChars((String)driveName), Text.escapeIllegalJcrChars((String)workspaceName), Text.escapeIllegalJcrChars((String)currentFolder));
                    String userId = ConversationState.getCurrent().getIdentity().getUserId();
                    return this.createProcessUploadResponse(Text.escapeIllegalJcrChars((String)workspaceName), currentFolderNode, currentPortal, userId, action, language, Text.escapeIllegalJcrChars((String)fileName), uploadId, existenceAction);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Error when perform processUpload: ", (Throwable)e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Response buildXMLResponseForChildren(Node node, String driveName, String currentFolder, boolean showHidden) throws Exception {
        Document document = this.createNewDocument();
        Element rootElement = this.createFolderElement(document, node, node.getSession().getWorkspace().getName(), driveName, currentFolder);
        Element folders = document.createElement("Folders");
        Element files = document.createElement("Files");
        Node referParentNode = node;
        if (node.isNodeType(EXO_SYMLINK) && node.hasProperty("exo:uuid") && node.hasProperty("exo:workspace")) {
            referParentNode = this.linkManager.getTarget(node);
        }
        NodeIterator iterator = referParentNode.getNodes();
        while (iterator.hasNext()) {
            Node sourceNode = null;
            Node referNode = null;
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable") && !showHidden) continue;
            if (child.isNodeType(EXO_SYMLINK) && child.hasProperty("exo:uuid") && child.hasProperty("exo:workspace")) {
                sourceNode = this.linkManager.getTarget(child);
            }
            referNode = sourceNode != null ? sourceNode : child;
            String workspaceName = referNode.getSession().getWorkspace().getName();
            if (this.isFolder(referNode)) {
                String folderPath = child.getPath();
                folderPath = folderPath.substring(folderPath.lastIndexOf("/") + 1, folderPath.length());
                String childFolder = StringUtils.isEmpty((String)currentFolder) ? folderPath : currentFolder.concat("/").concat(folderPath);
                Element folder = this.createFolderElement(document, child, workspaceName, driveName, childFolder);
                folders.appendChild(folder);
                continue;
            }
            if (!this.isFile(referNode)) continue;
            Element file = this.createFileElement(document, referNode, child, workspaceName);
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        document.appendChild(rootElement);
        return this.getResponse(document);
    }

    private boolean isFolder(Node checkNode) throws RepositoryException {
        return checkNode.isNodeType(NT_FOLDER) || checkNode.isNodeType(NT_UNSTRUCTURED);
    }

    private boolean isFile(Node checkNode) throws RepositoryException {
        return checkNode.isNodeType("nt:file");
    }

    private Element createFolderElement(Document document, Node node, String workspaceName, String driveName, String currentFolder) throws Exception {
        Element folder = document.createElement("Folder");
        boolean hasChild = false;
        boolean canRemove = true;
        boolean canAddChild = true;
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            if (!this.isFolder(iterator.nextNode())) continue;
            hasChild = true;
            break;
        }
        Session session = this.getSession(workspaceName);
        try {
            session.checkPermission(node.getPath(), "remove");
        }
        catch (Exception e) {
            canRemove = false;
        }
        try {
            session.checkPermission(node.getPath(), "add_node");
        }
        catch (Exception e) {
            canAddChild = false;
        }
        folder.setAttribute("name", node.getName());
        folder.setAttribute("title", Utils.getTitle((Node)node));
        folder.setAttribute("path", node.getPath());
        folder.setAttribute("canRemove", String.valueOf(canRemove));
        folder.setAttribute("canAddChild", String.valueOf(canAddChild));
        folder.setAttribute("nodeType", ManageDocumentService.getNodeTypeIcon(node));
        folder.setAttribute("workspaceName", workspaceName);
        folder.setAttribute("driveName", driveName);
        folder.setAttribute("currentFolder", currentFolder);
        folder.setAttribute("hasChild", String.valueOf(hasChild));
        folder.setAttribute("titlePath", this.createTitlePath(driveName, workspaceName, currentFolder));
        boolean isPublic = PermissionUtil.canAnyAccess((Node)node);
        folder.setAttribute("isPublic", String.valueOf(isPublic));
        CloudDrive cloudDrive = this.cloudDrives.findDrive(node);
        CloudFile cloudFile = null;
        if (cloudDrive != null && cloudDrive.isConnected()) {
            try {
                if (cloudDrive.isDrive(node)) {
                    folder.setAttribute("isCloudDrive", Boolean.TRUE.toString());
                    folder.setAttribute("isConnected", Boolean.TRUE.toString());
                    folder.setAttribute("cloudProvider", cloudDrive.getUser().getProvider().getId());
                } else {
                    cloudFile = cloudDrive.getFile(node.getPath());
                    if (cloudFile.isConnected()) {
                        if (cloudFile.isFolder()) {
                            folder.setAttribute("isCloudFile", Boolean.TRUE.toString());
                            folder.setAttribute("isConnected", Boolean.TRUE.toString());
                        }
                    } else {
                        folder.setAttribute("isCloudFile", Boolean.TRUE.toString());
                        folder.setAttribute("isConnected", Boolean.FALSE.toString());
                    }
                }
            }
            catch (NotYetCloudFileException e) {
                folder.setAttribute("isCloudFile", Boolean.TRUE.toString());
                folder.setAttribute("isConnected", Boolean.FALSE.toString());
            }
            catch (CloudDriveException e) {
                LOG.warn("Error reading cloud folder {}: {}", new Object[]{node.getPath(), e.getMessage()});
            }
        }
        if (cloudFile == null) {
            // empty if block
        }
        return folder;
    }

    private Element createFileElement(Document document, Node sourceNode, Node displayNode, String workspaceName) throws Exception {
        Element file = document.createElement("File");
        AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
        boolean canRemove = true;
        String sourcePath = sourceNode.getPath();
        file.setAttribute("name", Utils.getTitle((Node)displayNode));
        file.setAttribute("title", Utils.getTitle((Node)displayNode));
        file.setAttribute("workspaceName", workspaceName);
        file.setAttribute("id", sourceNode.getUUID());
        file.setAttribute("path", displayNode.getPath());
        file.setAttribute("isVersioned", String.valueOf(sourceNode.isNodeType("mix:versionable")));
        file.setAttribute("isVersionSupport", String.valueOf(autoVersionService.isVersionSupport(sourcePath, workspaceName)));
        if (sourceNode.isNodeType("nt:file")) {
            Node content = sourceNode.getNode("jcr:content");
            file.setAttribute("nodeType", content.getProperty("jcr:mimeType").getString());
        } else {
            file.setAttribute("nodeType", sourceNode.getPrimaryNodeType().getName());
        }
        try {
            this.getSession(workspaceName).checkPermission(sourcePath, "remove");
        }
        catch (Exception e) {
            canRemove = false;
        }
        file.setAttribute("canRemove", String.valueOf(canRemove));
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3);
        boolean isPublic = PermissionUtil.canAnyAccess((Node)sourceNode);
        file.setAttribute("isPublic", String.valueOf(isPublic));
        CloudDrive cloudDrive = this.cloudDrives.findDrive(sourceNode);
        CloudFile cloudFile = null;
        if (cloudDrive != null && cloudDrive.isConnected() && !cloudDrive.isDrive(sourceNode)) {
            try {
                cloudFile = cloudDrive.getFile(sourceNode.getPath());
                if (cloudFile.isConnected()) {
                    if (!cloudFile.isFolder()) {
                        file.setAttribute("isCloudFile", Boolean.TRUE.toString());
                        file.setAttribute("isConnected", Boolean.TRUE.toString());
                        file.setAttribute("dateCreated", formatter.format(cloudFile.getCreatedDate().getTime()));
                        file.setAttribute("dateModified", formatter.format(cloudFile.getModifiedDate().getTime()));
                        file.setAttribute("lastModifier", cloudFile.getLastUser());
                        file.setAttribute("creator", cloudFile.getAuthor());
                        file.setAttribute("size", String.valueOf(cloudFile.getSize()));
                    }
                } else {
                    file.setAttribute("isCloudFile", Boolean.TRUE.toString());
                    file.setAttribute("isConnected", Boolean.FALSE.toString());
                }
            }
            catch (NotYetCloudFileException e) {
                file.setAttribute("isCloudFile", Boolean.TRUE.toString());
                file.setAttribute("isConnected", Boolean.FALSE.toString());
            }
            catch (CloudDriveException e) {
                LOG.warn("Error reading cloud file {}: {}", new Object[]{sourceNode.getPath(), e.getMessage()});
            }
        }
        if (cloudFile == null) {
            file.setAttribute("dateCreated", formatter.format(sourceNode.getProperty("exo:dateCreated").getDate().getTime()));
            if (sourceNode.hasProperty("exo:dateModified")) {
                file.setAttribute("dateModified", formatter.format(sourceNode.getProperty("exo:dateModified").getDate().getTime()));
            } else {
                file.setAttribute("dateModified", null);
            }
            if (sourceNode.hasProperty("exo:lastModifier")) {
                file.setAttribute("lastModifier", sourceNode.getProperty("exo:lastModifier").getString());
            } else {
                file.setAttribute("lastModifier", null);
            }
            file.setAttribute("creator", sourceNode.getProperty("exo:owner").getString());
            long size = sourceNode.getNode("jcr:content").getProperty("jcr:data").getLength();
            file.setAttribute("size", String.valueOf(size));
        }
        return file;
    }

    private Node getNode(String driveName, String workspaceName, String currentFolder) throws Exception {
        Session session = this.getSession(workspaceName);
        String driveHomePath = this.manageDriveService.getDriveByName(Text.escapeIllegalJcrChars((String)driveName)).getHomePath();
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        String drivePath = Utils.getPersonalDrivePath((String)driveHomePath, (String)userId);
        Node node = (Node)session.getItem(Text.escapeIllegalJcrChars((String)drivePath));
        if (StringUtils.isEmpty((String)currentFolder)) {
            return node;
        }
        for (String folder : currentFolder.split("/")) {
            if (node.hasNode(folder)) {
                if (!(node = node.getNode(folder)).isNodeType(EXO_SYMLINK)) continue;
                node = this.linkManager.getTarget(node);
                continue;
            }
            if (node.isNodeType(EXO_SYMLINK)) {
                node = this.linkManager.getTarget(node).getNode(folder);
                continue;
            }
            return node;
        }
        return node;
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ManageableRepository manageableRepository = this.getCurrentRepository();
        return sessionProvider.getSession(workspaceName, manageableRepository);
    }

    private Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    private ManageableRepository getCurrentRepository() throws RepositoryException {
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    private Response getResponse(Document document) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(this.cc).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Element buildXMLDriveNodes(Document document, List<DriveData> drivesList, String driveType) throws Exception {
        Element folders = document.createElement("Folders");
        folders.setAttribute("name", driveType);
        for (DriveData drive : drivesList) {
            Element folder = document.createElement("Folder");
            folder.setAttribute("name", drive.getName());
            folder.setAttribute("nodeType", driveType + " " + drive.getName().replaceAll(" ", "_"));
            folder.setAttribute("workspaceName", drive.getWorkspace());
            folder.setAttribute("canAddChild", drive.getAllowCreateFolders());
            folders.appendChild(folder);
        }
        return folders;
    }

    private List<String> getMemberships() throws Exception {
        ArrayList<String> userMemberships = new ArrayList<String>();
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        userMemberships.add(userId);
        Collection memberships = ConversationState.getCurrent().getIdentity().getMemberships();
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            MembershipEntry membership = (MembershipEntry)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroup();
            userMemberships.add(role);
        }
        return userMemberships;
    }

    public static String getNodeTypeIcon(Node node) throws RepositoryException {
        StringBuilder str = new StringBuilder();
        if (node == null) {
            return "";
        }
        String nodeType = node.getPrimaryNodeType().getName();
        if (node.isNodeType(EXO_SYMLINK)) {
            LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
            try {
                nodeType = node.getProperty(EXO_PRIMARYTYPE).getString();
                node = linkManager.getTarget(node);
                if (node == null) {
                    return "";
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        if (node.isNodeType(EXO_TRASH_FOLDER)) {
            nodeType = EXO_TRASH_FOLDER;
        }
        if (node.isNodeType(EXO_FAVOURITE_FOLDER)) {
            nodeType = EXO_FAVOURITE_FOLDER;
        }
        if (nodeType.equals(NT_UNSTRUCTURED) || nodeType.equals(NT_FOLDER)) {
            for (String specificFolder : SPECIFIC_FOLDERS) {
                if (!node.isNodeType(specificFolder)) continue;
                nodeType = specificFolder;
                break;
            }
        }
        str.append(nodeType);
        return str.toString();
    }

    protected Response createProcessUploadResponse(String workspaceName, Node currentFolderNode, String siteName, String userId, String action, String language, String fileName, String uploadId, String existenceAction) throws Exception {
        if ("save".equals(action)) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", true);
            return this.fileUploadHandler.saveAsNTFile(workspaceName, currentFolderNode, uploadId, fileName, language, siteName, userId, existenceAction);
        }
        return this.fileUploadHandler.control(uploadId, action);
    }

    private String createTitlePath(String driveName, String workspaceName, String currentFolder) throws Exception {
        String[] folders = currentFolder.split("/");
        StringBuilder sb = new StringBuilder();
        StringBuilder tempFolder = new StringBuilder();
        Node parentNode = this.getNode(driveName, workspaceName, "");
        if (StringUtils.isEmpty((String)currentFolder)) {
            return "";
        }
        for (int i = 0; i < folders.length; ++i) {
            tempFolder = tempFolder.append(folders[i]);
            Node node = null;
            try {
                node = this.getNode(driveName, workspaceName, tempFolder.toString());
            }
            catch (PathNotFoundException e) {
                node = parentNode.getNode(folders[i]);
            }
            tempFolder = tempFolder.append("/");
            sb.append(Utils.getTitle((Node)node));
            if (i != folders.length - 1) {
                sb.append("/");
            }
            parentNode = node.isNodeType(EXO_SYMLINK) ? this.linkManager.getTarget(node) : node;
        }
        return sb.toString();
    }

    private static enum DriveType {
        GENERAL,
        GROUP,
        PERSONAL;

    }
}

