/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DriveItemVersion;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemVersionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemVersionCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemVersionCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DriveItemVersionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemVersionCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemVersionCollectionRequest;

public class DriveItemVersionCollectionRequest
extends BaseCollectionRequest<DriveItemVersionCollectionResponse, IDriveItemVersionCollectionPage>
implements IDriveItemVersionCollectionRequest {
    public DriveItemVersionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItemVersionCollectionResponse.class, IDriveItemVersionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemVersionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveItemVersionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemVersionCollectionPage get() throws ClientException {
        DriveItemVersionCollectionResponse response = (DriveItemVersionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DriveItemVersion newDriveItemVersion, ICallback<DriveItemVersion> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DriveItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDriveItemVersion, callback);
    }

    @Override
    public DriveItemVersion post(DriveItemVersion newDriveItemVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDriveItemVersion);
    }

    @Override
    public IDriveItemVersionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDriveItemVersionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemVersionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDriveItemVersionCollectionPage buildFromResponse(DriveItemVersionCollectionResponse response) {
        DriveItemVersionCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemVersionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveItemVersionCollectionPage page = new DriveItemVersionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

