/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import javax.jcr.Node;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.component.admin.views.UIViewPermissionContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewPermissionList;
import org.exoplatform.ecm.webui.core.UIPermissionFormBase;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.selector.UIGroupMemberSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/view/UIViewPermissionForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddAnyActionListener.class})})
public class UIViewPermissionForm
extends UIPermissionFormBase
implements UISelectable {
    public static final String TAB_PERMISSION = "permission";

    public UIViewPermissionForm() throws Exception {
        this.removeChildById(TAB_PERMISSION);
        this.addChild((UIComponent)new UIPermissionInputSet(TAB_PERMISSION));
        UIPermissionInputSet uiPerInputset = (UIPermissionInputSet)this.getChildById(TAB_PERMISSION);
        uiPerInputset.setButtonActions(new String[]{"Add"});
        uiPerInputset.setPrimaryButtonAction("Add");
        uiPerInputset.setActionInfo("userOrGroup", new String[]{"SelectUser", "SelectMember"});
    }

    public void doSelect(String selectField, Object value) {
        this.getUIStringInput(selectField).setValue((Object)value.toString());
    }

    public Node getCurrentNode() throws Exception {
        return null;
    }

    public static class AddActionListener
    extends EventListener<UIViewPermissionForm> {
        public void execute(Event<UIViewPermissionForm> event) throws Exception {
            UIViewPermissionForm uiForm = (UIViewPermissionForm)((Object)event.getSource());
            UIViewPermissionContainer uiContainer = (UIViewPermissionContainer)uiForm.getParent();
            UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiContainer.getParent();
            UIViewForm uiViewForm = (UIViewForm)uiTabPane.getChild(UIViewForm.class);
            UIViewPermissionList uiList = (UIViewPermissionList)uiContainer.getChild(UIViewPermissionList.class);
            String permission = (String)uiForm.getUIStringInput("userOrGroup").getValue();
            String strPermission = uiViewForm.getPermission();
            if (Utils.isNameEmpty((String)permission)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.userOrGroup-required", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
                uiTabPane.setSelectedTab(uiContainer.getId());
                return;
            }
            if (strPermission.contains(permission)) {
                UIApplication app = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{permission};
                app.addMessage(new ApplicationMessage("UIViewPermissionForm.msg.permission-exist", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
                uiTabPane.setSelectedTab(uiContainer.getId());
                return;
            }
            StringBuilder strBuilder = new StringBuilder(strPermission);
            if (strPermission.length() > 0) {
                strBuilder = strBuilder.append(",");
            }
            strBuilder.append(permission);
            uiViewForm.setPermission(strBuilder.toString());
            uiList.refresh(uiList.getUIPageIterator().getCurrentPage());
            uiForm.getUIStringInput("userOrGroup").setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class SelectMemberActionListener
    extends EventListener<UIViewPermissionForm> {
        public void execute(Event<UIViewPermissionForm> event) throws Exception {
            UIViewPermissionForm uiForm = (UIViewPermissionForm)((Object)event.getSource());
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)uiForm.createUIComponent(UIGroupMemberSelector.class, null, null);
            uiGroupMemberSelector.setShowAnyPermission(false);
            uiGroupMemberSelector.setSourceComponent((UIComponent)uiForm, new String[]{"userOrGroup"});
            ((UIPermissionManagerBase)uiForm.getAncestorOfType(UIPermissionManagerBase.class)).initPopupPermission((UIComponent)uiGroupMemberSelector);
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class AddAnyActionListener
    extends EventListener<UIViewPermissionForm> {
        public void execute(Event<UIViewPermissionForm> event) throws Exception {
            UIViewPermissionForm uiForm = (UIViewPermissionForm)((Object)event.getSource());
            UIPermissionInputSet uiInputSet = (UIPermissionInputSet)uiForm.getChildById(UIViewPermissionForm.TAB_PERMISSION);
            uiInputSet.getUIStringInput("userOrGroup").setValue((Object)IdentityConstants.ANY);
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class SelectUserActionListener
    extends EventListener<UIViewPermissionForm> {
        public void execute(Event<UIViewPermissionForm> event) throws Exception {
            UIViewPermissionForm uiForm = (UIViewPermissionForm)((Object)event.getSource());
            ((UIPermissionManagerBase)uiForm.getParent()).initUserSelector();
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }
}

