/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.utils;

import java.util.LinkedHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.model.Permission;
import org.exoplatform.services.attachments.rest.model.AttachmentEntity;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.entity.IdentityEntity;

public class EntityBuilder {
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);
    private static final String IDENTITIES_REST_PATH = "/v1/social/identities";
    private static final String IDENTITIES_EXPAND = "all";

    public static final AttachmentEntity fromAttachment(IdentityManager identityManager, Attachment attachment) {
        return new AttachmentEntity(attachment.getId(), attachment.getTitle(), attachment.getSize(), attachment.getMimetype(), attachment.getPath(), attachment.getIsPublic(), attachment.getAcl(), null, attachment.getCreated(), EntityBuilder.getIdentityEntity(identityManager, attachment.getUpdater()), attachment.getUpdated(), attachment.getDownloadUrl(), attachment.getOpenUrl(), attachment.getPreviewBreadcrumb(), attachment.getVersion());
    }

    public static final Attachment fromAttachmentNode(RepositoryService repositoryService, DocumentService documentService, LinkManager linkManager, String workspace, Session session, String attachmentId) throws Exception {
        Node attachmentNode = null;
        Permission acl = new Permission();
        try {
            attachmentNode = session.getNodeByUUID(attachmentId);
        }
        catch (AccessDeniedException e) {
            Attachment privateAttachment = new Attachment();
            acl.setCanAccess(false);
            privateAttachment.setAcl(acl);
            return privateAttachment;
        }
        if (attachmentNode == null) {
            throw new ObjectNotFoundException("Node with id " + attachmentId + " wasn't found");
        }
        if (linkManager.isLink((Item)attachmentNode) && (attachmentNode = linkManager.getTarget(attachmentNode)) == null) {
            throw new ObjectNotFoundException("Target Node with of symlink " + attachmentId + " wasn't found");
        }
        Attachment attachment = new Attachment();
        attachment.setId(attachmentNode.getUUID());
        String attachmentsTitle = EntityBuilder.getStringProperty(attachmentNode, "exo:title");
        attachment.setTitle(attachmentsTitle);
        String attachmentsPath = attachmentNode.getPath();
        attachment.setPath(attachmentsPath);
        attachment.setCreated(EntityBuilder.getStringProperty(attachmentNode, "exo:dateCreated"));
        if (attachmentNode.hasProperty("exo:dateModified")) {
            attachment.setUpdated(EntityBuilder.getStringProperty(attachmentNode, "exo:dateModified"));
        } else {
            attachment.setUpdated(null);
        }
        if (attachmentNode.hasProperty("exo:lastModifier")) {
            attachment.setUpdater(EntityBuilder.getStringProperty(attachmentNode, "exo:lastModifier"));
        } else {
            attachment.setUpdater(null);
        }
        DMSMimeTypeResolver mimeTypeResolver = DMSMimeTypeResolver.getInstance();
        String mimetype = mimeTypeResolver.getMimeType(attachmentsTitle);
        attachment.setMimetype(mimetype);
        long size = attachmentNode.getNode("jcr:content").getProperty("jcr:data").getLength();
        attachment.setSize(size);
        String downloadUrl = EntityBuilder.getDownloadUrl(repositoryService, workspace, attachmentsPath);
        attachment.setDownloadUrl(downloadUrl);
        String openUrl = EntityBuilder.getUrl(documentService, attachmentsPath);
        attachment.setOpenUrl(openUrl);
        String attachmentsVersion = EntityBuilder.getStringProperty(attachmentNode, "exo:baseVersion");
        attachment.setVersion(attachmentsVersion);
        LinkedHashMap<String, String> previewBreadcrumb = new LinkedHashMap();
        try {
            previewBreadcrumb = documentService.getFilePreviewBreadCrumb(attachmentNode);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting file preview breadcrumb " + attachmentNode.getUUID()), (Throwable)e);
        }
        attachment.setPreviewBreadcrumb(previewBreadcrumb);
        acl.setCanAccess(true);
        attachment.setAcl(acl);
        return attachment;
    }

    private static IdentityEntity getIdentityEntity(IdentityManager identityManager, String ownerId) {
        Identity identity = EntityBuilder.getIdentity(identityManager, ownerId);
        if (identity == null) {
            return null;
        }
        return org.exoplatform.social.rest.api.EntityBuilder.buildEntityIdentity((Identity)identity, (String)IDENTITIES_REST_PATH, (String)IDENTITIES_EXPAND);
    }

    private static final Identity getIdentity(IdentityManager identityManager, String identityId) {
        return identityManager.getOrCreateIdentity("organization", identityId);
    }

    private static String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    private static String getDownloadUrl(RepositoryService repositoryService, String workspace, String nodePath) {
        String restContextName = WCMCoreUtils.getRestContextName();
        String repositoryName = EntityBuilder.getRepositoryName(repositoryService);
        StringBuffer downloadUrl = new StringBuffer();
        downloadUrl.append('/').append(restContextName).append("/jcr/").append(repositoryName).append('/').append(workspace).append(nodePath);
        return downloadUrl.toString();
    }

    private static String getUrl(DocumentService documentService, String nodePath) {
        String url = "";
        try {
            url = documentService.getLinkInDocumentsApp(nodePath);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get url of document " + nodePath), (Throwable)e);
        }
        return url;
    }

    private static String getRepositoryName(RepositoryService repositoryService) {
        try {
            return repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            LOG.debug((Object)"Cannot get repository name", (Throwable)e);
            return "repository";
        }
    }
}

