/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.notification.plugin;

import javax.jcr.Node;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ShareFileToUserPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(ShareFileToUserPlugin.class);
    public static final String ID = "ShareFileToUserPlugin";
    public static final String FIRSTNAME = "firstName";
    public static final String DOCUMENT_URL = "documentUrl";
    public static final String DOCUMENT_NAME = "documentName";
    public static final String DOCUMENT_ICON = "documentIcon";
    public static final String COMMENT = "comment";
    public static final String PERMISSION = "permission";
    public static final String TYPE = "type";
    public static final String NODE_ID = "nodeId";
    public static ArgumentLiteral<Node> NODE = new ArgumentLiteral(Node.class, "node");
    public static ArgumentLiteral<String> SENDER = new ArgumentLiteral(String.class, "sender");
    public static ArgumentLiteral<String> NODEID = new ArgumentLiteral(String.class, "nodeId");
    public static ArgumentLiteral<String> RECEIVER = new ArgumentLiteral(String.class, "receiver");
    public static ArgumentLiteral<String> PERM = new ArgumentLiteral(String.class, "perm");
    public static ArgumentLiteral<String> URL = new ArgumentLiteral(String.class, "url");
    public static ArgumentLiteral<String> MESSAGE = new ArgumentLiteral(String.class, "message");
    public static ArgumentLiteral<String> ICON = new ArgumentLiteral(String.class, "icon");
    public static ArgumentLiteral<String> MIMETYPE = new ArgumentLiteral(String.class, "mimeType");

    public ShareFileToUserPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String receiver = (String)ctx.value(RECEIVER);
        Node node = (Node)ctx.value(NODE);
        try {
            return NotificationInfo.instance().setFrom((String)ctx.value(SENDER)).to(receiver).with(NODE_ID, (String)ctx.value(NODEID)).with(FIRSTNAME, this.capitalizeFirstLetter(receiver)).with(DOCUMENT_URL, (String)ctx.value(URL)).with(DOCUMENT_NAME, Utils.getTitle((Node)node)).with(DOCUMENT_ICON, (String)ctx.value(ICON)).with(PERMISSION, (String)ctx.value(PERM)).with(COMMENT, (String)ctx.value(MESSAGE)).with(TYPE, (String)ctx.value(MIMETYPE)).key(this.getId()).end();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return NotificationInfo.instance().setFrom((String)ctx.value(SENDER)).to(receiver).with(COMMENT, (String)ctx.value(MESSAGE)).key(this.getId()).end();
        }
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }
}

