/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.administration;

import java.util.ArrayList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/Editing/UIEditingToolBar.gtmpl", events={@EventConfig(listeners={ChangeEditingActionListener.class})})
public class UIEditingForm
extends UIForm {
    public static final String PUBLISHED = "Published";
    public static final String DRAFT = "Draft";
    public static final String EDITING_OPTIONS = "EditingOptions";

    public UIEditingForm() {
        ArrayList<SelectItemOption> editingOptions = new ArrayList<SelectItemOption>();
        editingOptions.add(new SelectItemOption(PUBLISHED, (Object)PUBLISHED));
        editingOptions.add(new SelectItemOption(DRAFT, (Object)DRAFT));
        UIFormSelectBox orderBySelectBox = new UIFormSelectBox(EDITING_OPTIONS, EDITING_OPTIONS, editingOptions);
        orderBySelectBox.setOnChange("ChangeEditing");
        this.addChild((UIComponent)orderBySelectBox);
    }

    public static class ChangeEditingActionListener
    extends EventListener<UIEditingForm> {
        public void execute(Event<UIEditingForm> event) throws Exception {
            UIEditingForm editingForm = (UIEditingForm)((Object)event.getSource());
            PortalRequestContext context = Util.getPortalRequestContext();
            UIFormSelectBox options = (UIFormSelectBox)editingForm.getChildById(UIEditingForm.EDITING_OPTIONS);
            String option = (String)options.getValue();
            if (option.equals(UIEditingForm.PUBLISHED)) {
                context.getRequest().getSession().setAttribute("turnOnQuickEdit", (Object)false);
                Utils.updatePortal((PortletRequestContext)((PortletRequestContext)event.getRequestContext()));
            } else {
                context.getRequest().getSession().setAttribute("turnOnQuickEdit", (Object)true);
                Utils.updatePortal((PortletRequestContext)((PortletRequestContext)event.getRequestContext()));
            }
        }
    }
}

