/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.TemplateConfig;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ManageViewPlugin
extends BaseComponentPlugin {
    private static String ECM_EXPLORER_TEMPLATE = "ecmExplorerTemplate";
    public static final String EDITED_CONFIGURED_VIEWS = "EditedConfiguredViews";
    public static final String EDITED_CONFIGURED_VIEWS_TEMPLATES = "EditedConfiguredViewsTemplate";
    private InitParams params_;
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private ConfigurationManager cservice_;
    private boolean autoCreateInNewRepository_ = false;
    private String predefinedViewsLocation_ = "war:/conf/dms/artifacts";
    private DMSConfiguration dmsConfiguration_;
    private TemplateService templateService;
    private Set<String> configuredTemplate_;
    private Set<String> configuredViews_;

    public ManageViewPlugin(RepositoryService repositoryService, InitParams params, ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration) throws Exception {
        ValueParam predefinedViewLocation;
        this.params_ = params;
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.cservice_ = cservice;
        ValueParam autoInitParam = params.getValueParam("autoCreateInNewRepository");
        if (autoInitParam != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(autoInitParam.getValue());
        }
        if ((predefinedViewLocation = params.getValueParam("predefinedViewsLocation")) != null) {
            this.predefinedViewsLocation_ = predefinedViewLocation.getValue();
        }
        this.dmsConfiguration_ = dmsConfiguration;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository_) {
            this.importPredefineViews();
            return;
        }
    }

    private void importPredefineViews() throws Exception {
        this.configuredTemplate_ = new HashSet<String>();
        this.configuredViews_ = new HashSet<String>();
        Iterator it = this.params_.getObjectParamIterator();
        String viewsPath = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        String templatesPath = this.nodeHierarchyCreator_.getJcrPath("viewTemplatesPath");
        String warViewPath = this.predefinedViewsLocation_ + templatesPath.substring(templatesPath.lastIndexOf("exo:ecm") + 7);
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        Session session = manageableRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
        ViewConfig viewObject = null;
        TemplateConfig templateObject = null;
        Node viewHomeNode = (Node)session.getItem(viewsPath);
        while (it.hasNext()) {
            Object object = ((ObjectParameter)it.next()).getObject();
            if (object instanceof ViewConfig) {
                viewObject = (ViewConfig)object;
                String viewNodeName = viewObject.getName();
                this.configuredViews_.add(viewNodeName);
                if (viewHomeNode.hasNode(viewNodeName) || Utils.getAllEditedConfiguredData(((Object)((Object)this)).getClass().getSimpleName(), EDITED_CONFIGURED_VIEWS, true).contains(viewNodeName)) continue;
                Node viewNode = this.addView(viewHomeNode, viewNodeName, viewObject.getPermissions(), viewObject.isHideExplorerPanel(), viewObject.getTemplate());
                for (ViewConfig.Tab tab : viewObject.getTabList()) {
                    this.addTab(viewNode, tab.getTabName(), tab.getButtons());
                }
                continue;
            }
            if (!(object instanceof TemplateConfig)) continue;
            templateObject = (TemplateConfig)object;
            this.addTemplate(templateObject, session, warViewPath);
            this.configuredTemplate_.add(templateObject.getName());
        }
        session.save();
        session.logout();
    }

    private Node addView(Node viewManager, String viewName, String permissions, boolean hideExplorerPanel, String template) throws Exception {
        Node contentNode = viewManager.addNode(viewName, "exo:view");
        contentNode.setProperty("exo:accessPermissions", permissions);
        contentNode.setProperty("exo:template", template);
        if (contentNode.hasProperty("exo:hideExplorerPanel")) {
            contentNode.setProperty("exo:hideExplorerPanel", hideExplorerPanel);
        }
        viewManager.save();
        return contentNode;
    }

    private void addTab(Node view, String tabName, String buttons) throws Exception {
        Node tab = view.hasNode(tabName) ? view.getNode(tabName) : view.addNode(tabName, "exo:tab");
        tab.setProperty("exo:buttons", buttons);
        view.save();
    }

    private void addTemplate(TemplateConfig tempObject, Session session, String warViewPath) throws Exception {
        String templateName;
        String templateHomePath;
        Node templateHomeNode;
        String type = tempObject.getTemplateType();
        String alias = "";
        if (type.equals(ECM_EXPLORER_TEMPLATE)) {
            alias = "ecmExplorerTemplates";
        }
        if ((templateHomeNode = (Node)session.getItem(templateHomePath = this.nodeHierarchyCreator_.getJcrPath(alias))).hasNode(templateName = tempObject.getName()) || Utils.getAllEditedConfiguredData(((Object)((Object)this)).getClass().getSimpleName(), EDITED_CONFIGURED_VIEWS_TEMPLATES, true).contains(templateName)) {
            return;
        }
        String warPath = warViewPath + tempObject.getWarPath();
        InputStream in = this.cservice_.getInputStream(warPath);
        this.templateService.createTemplate(templateHomeNode, templateName, templateName, in, new String[]{"*"});
    }

    public Set<String> getConfiguredTemplates() {
        return this.configuredTemplate_;
    }

    public Set<String> getConfiguredViews() {
        return this.configuredViews_;
    }
}

