/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ConversationThread;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ConversationThreadCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ConversationThreadCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ConversationThreadCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ConversationThreadRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IConversationThreadCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IConversationThreadCollectionRequest;

public class ConversationThreadCollectionRequest
extends BaseCollectionRequest<ConversationThreadCollectionResponse, IConversationThreadCollectionPage>
implements IConversationThreadCollectionRequest {
    public ConversationThreadCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConversationThreadCollectionResponse.class, IConversationThreadCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IConversationThreadCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ConversationThreadCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IConversationThreadCollectionPage get() throws ClientException {
        ConversationThreadCollectionResponse response = (ConversationThreadCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ConversationThread newConversationThread, ICallback<ConversationThread> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ConversationThreadRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newConversationThread, callback);
    }

    @Override
    public ConversationThread post(ConversationThread newConversationThread) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationThreadRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newConversationThread);
    }

    @Override
    public IConversationThreadCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IConversationThreadCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IConversationThreadCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IConversationThreadCollectionPage buildFromResponse(ConversationThreadCollectionResponse response) {
        ConversationThreadCollectionRequestBuilder builder = response.nextLink != null ? new ConversationThreadCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ConversationThreadCollectionPage page = new ConversationThreadCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

