/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SharedInsight;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISharedInsightCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISharedInsightCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedInsightCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedInsightCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedInsightCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SharedInsightRequestBuilder;

public class SharedInsightCollectionRequest
extends BaseCollectionRequest<SharedInsightCollectionResponse, ISharedInsightCollectionPage>
implements ISharedInsightCollectionRequest {
    public SharedInsightCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SharedInsightCollectionResponse.class, ISharedInsightCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISharedInsightCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SharedInsightCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISharedInsightCollectionPage get() throws ClientException {
        SharedInsightCollectionResponse response = (SharedInsightCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SharedInsight newSharedInsight, ICallback<SharedInsight> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SharedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSharedInsight, callback);
    }

    @Override
    public SharedInsight post(SharedInsight newSharedInsight) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SharedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSharedInsight);
    }

    @Override
    public ISharedInsightCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISharedInsightCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISharedInsightCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISharedInsightCollectionPage buildFromResponse(SharedInsightCollectionResponse response) {
        SharedInsightCollectionRequestBuilder builder = response.nextLink != null ? new SharedInsightCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SharedInsightCollectionPage page = new SharedInsightCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

