/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.activity.listener;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;

public class FileActivityListener
extends ActivityListenerPlugin {
    public static final String DOCPATH = "DOCPATH";
    public static final String NODEPATH_NAME = "nodePath";
    private static final Log LOG = ExoLogger.getLogger(FileActivityListener.class);
    private IShareDocumentService shareDocumentService;
    private ActivityManager activityManager;

    public FileActivityListener(ActivityManager activityManager, IShareDocumentService shareDocumentService) {
        this.shareDocumentService = shareDocumentService;
        this.activityManager = activityManager;
    }

    public void shareActivity(ActivityLifeCycleEvent event) {
        String originalActivityId;
        ExoSocialActivity originalActivity;
        ExoSocialActivity sharedActivity = event.getActivity();
        if (sharedActivity != null && sharedActivity.getTemplateParams() != null && sharedActivity.getTemplateParams().containsKey("originalActivityId") && (originalActivity = this.activityManager.getActivity(originalActivityId = (String)sharedActivity.getTemplateParams().get("originalActivityId"))) != null && originalActivity.getTemplateParams() != null && !sharedActivity.isComment() && sharedActivity.getActivityStream() != null && (originalActivity.getTemplateParams().containsKey(DOCPATH) || originalActivity.getTemplateParams().containsKey(NODEPATH_NAME))) {
            try {
                this.shareDocumentService.shareDocumentActivityToSpace(sharedActivity);
            }
            catch (Exception e) {
                LOG.error("Error while sharing files of activity {}", new Object[]{sharedActivity.getId(), e});
            }
        }
    }
}

