/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http.HttpExtractor;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http.HttpRequestContext;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http.util.HttpTraceUtil;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.tags.TagContext;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.AttributeValue;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.MessageEvent;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.Span;

abstract class AbstractHttpHandler<Q, P> {
    @VisibleForTesting
    final HttpExtractor<Q, P> extractor;

    AbstractHttpHandler(HttpExtractor<Q, P> extractor) {
        Preconditions.checkNotNull(extractor, (Object)"extractor");
        this.extractor = extractor;
    }

    static void recordMessageEvent(Span span, long id, MessageEvent.Type type, long uncompressedMessageSize, long compressedMessageSize) {
        MessageEvent messageEvent = MessageEvent.builder(type, id).setUncompressedMessageSize(uncompressedMessageSize).setCompressedMessageSize(compressedMessageSize).build();
        span.addMessageEvent(messageEvent);
    }

    private static void putAttributeIfNotEmptyOrNull(Span span, String key, @Nullable String value) {
        if (value != null && !value.isEmpty()) {
            span.putAttribute(key, AttributeValue.stringAttributeValue(value));
        }
    }

    public final void handleMessageSent(HttpRequestContext context, long bytes) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        context.sentMessageSize.addAndGet(bytes);
        if (context.span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            AbstractHttpHandler.recordMessageEvent(context.span, context.sentSeqId.addAndGet(1L), MessageEvent.Type.SENT, bytes, 0L);
        }
    }

    public final void handleMessageReceived(HttpRequestContext context, long bytes) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        context.receiveMessageSize.addAndGet(bytes);
        if (context.span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            AbstractHttpHandler.recordMessageEvent(context.span, context.receviedSeqId.addAndGet(1L), MessageEvent.Type.RECEIVED, bytes, 0L);
        }
    }

    void spanEnd(Span span, @Nullable P response, @Nullable Throwable error) {
        int statusCode = this.extractor.getStatusCode(response);
        if (span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            span.putAttribute("http.status_code", AttributeValue.longAttributeValue(statusCode));
        }
        span.setStatus(HttpTraceUtil.parseResponseStatus(statusCode, error));
        span.end();
    }

    final String getSpanName(Q request, HttpExtractor<Q, P> extractor) {
        String path = extractor.getPath(request);
        if (path == null) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    final void addSpanRequestAttributes(Span span, Q request, HttpExtractor<Q, P> extractor) {
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.user_agent", extractor.getUserAgent(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.host", extractor.getHost(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.method", extractor.getMethod(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.path", extractor.getPath(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.route", extractor.getRoute(request));
        AbstractHttpHandler.putAttributeIfNotEmptyOrNull(span, "http.url", extractor.getUrl(request));
    }

    public Span getSpanFromContext(HttpRequestContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        return context.span;
    }

    HttpRequestContext getNewContext(Span span, TagContext tagContext) {
        return new HttpRequestContext(span, tagContext);
    }
}

