/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.RasterOps;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.PColorSpace;

public class PColorSpaceRasterOp
implements RasterOp {
    private RenderingHints hints = null;
    private PColorSpace colorSpace;

    public PColorSpaceRasterOp(PColorSpace colorSpace, RenderingHints hints) {
        this.hints = hints;
        this.colorSpace = colorSpace;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        byte[] srcPixels = ((DataBufferByte)src.getDataBuffer()).getData();
        int[] destPixels = ((DataBufferInt)dest.getDataBuffer()).getData();
        if (this.colorSpace instanceof DeviceRGB) {
            int bands = src.getNumBands();
            int[] rgbValues = new int[3];
            int pixel = 0;
            int intPixels = 0;
            while (pixel < srcPixels.length) {
                rgbValues[0] = srcPixels[pixel] & 0xFF;
                rgbValues[1] = srcPixels[pixel + 1] & 0xFF;
                rgbValues[2] = srcPixels[pixel + 2] & 0xFF;
                destPixels[intPixels] = (rgbValues[0] & 0xFF) << 16 | (rgbValues[1] & 0xFF) << 8 | rgbValues[2] & 0xFF;
                pixel += bands;
                ++intPixels;
            }
        } else {
            int bands = src.getNumBands();
            float[] values = new float[3];
            int pixel = 0;
            int intPixels = 0;
            while (pixel < srcPixels.length) {
                for (int i = 0; i < bands; ++i) {
                    values[i] = (float)(srcPixels[pixel + i] & 0xFF) / 255.0f;
                }
                PColorSpace.reverseInPlace(values);
                destPixels[intPixels] = this.colorSpace.getColor(values).getRGB();
                pixel += bands;
                ++intPixels;
            }
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = (Point2D)srcPt.clone();
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

