/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives;

import java.util.Calendar;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.CloudDriveEnvironment;
import org.exoplatform.services.cms.clouddrives.CloudDriveEvent;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveListener;
import org.exoplatform.services.cms.clouddrives.CloudDriveMessage;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudFileSynchronizer;
import org.exoplatform.services.cms.clouddrives.CloudProviderException;
import org.exoplatform.services.cms.clouddrives.CloudUser;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotCloudDriveException;
import org.exoplatform.services.cms.clouddrives.NotCloudFileException;
import org.exoplatform.services.cms.clouddrives.NotConnectedException;
import org.exoplatform.services.cms.clouddrives.NotYetCloudFileException;
import org.exoplatform.services.cms.clouddrives.RefreshAccessException;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class CloudDrive {
    protected static final Log LOG = ExoLogger.getLogger(CloudDrive.class);
    protected final ListenerSupport listeners = new ListenerSupport();

    public String toString() {
        return this.title() + " " + super.toString();
    }

    public void addListener(CloudDriveListener listener) {
        if (!this.listeners.registry.contains(listener)) {
            this.listeners.registry.add(listener);
        }
    }

    public void removeListener(CloudDriveListener listener) {
        this.listeners.registry.remove(listener);
    }

    public abstract CloudUser getUser();

    public abstract String getTitle() throws DriveRemovedException, RepositoryException;

    public abstract String getLink() throws DriveRemovedException, NotConnectedException, RepositoryException;

    public abstract FilesState getState() throws DriveRemovedException, RefreshAccessException, CloudProviderException, RepositoryException;

    public abstract String getLocalUser() throws DriveRemovedException, RepositoryException;

    public abstract Calendar getInitDate() throws DriveRemovedException, RepositoryException;

    public abstract Calendar getConnectDate() throws DriveRemovedException, NotConnectedException, RepositoryException;

    public abstract String getPath() throws DriveRemovedException, RepositoryException;

    public abstract String getWorkspace() throws DriveRemovedException, RepositoryException;

    public abstract String getId() throws DriveRemovedException, NotConnectedException, RepositoryException;

    public abstract CloudFile getFile(String var1) throws DriveRemovedException, NotCloudDriveException, NotCloudFileException, NotYetCloudFileException, RepositoryException;

    public abstract boolean hasFile(String var1) throws DriveRemovedException, NotCloudDriveException, RepositoryException;

    public abstract Collection<CloudFile> listFiles() throws DriveRemovedException, CloudDriveException, RepositoryException;

    public abstract Command connect() throws CloudDriveException, RepositoryException;

    public abstract Command synchronize() throws SyncNotSupportedException, DriveRemovedException, CloudDriveException, RepositoryException;

    public abstract boolean isConnected() throws DriveRemovedException, RepositoryException;

    public abstract boolean isDrive(Node var1) throws DriveRemovedException, RepositoryException;

    protected void initCreated() throws RepositoryException, DriveRemovedException {
        this.listeners.fireOnCreated(new CloudDriveEvent(this.getUser(), this.getLocalUser(), this.getWorkspace(), this.getPath(), this.title()));
    }

    protected abstract boolean isInDrive(Node var1) throws DriveRemovedException, RepositoryException;

    protected abstract boolean isDrive(String var1, String var2, boolean var3) throws DriveRemovedException, RepositoryException;

    protected abstract void disconnect() throws DriveRemovedException, CloudDriveException, RepositoryException;

    protected abstract void refreshAccess() throws CloudDriveException;

    protected abstract void updateAccess(CloudUser var1) throws CloudDriveException, RepositoryException;

    protected abstract String title();

    protected abstract void configure(CloudDriveEnvironment var1, Collection<CloudFileSynchronizer> var2);

    protected abstract void initRemove(Node var1) throws SyncNotSupportedException, CloudDriveException, RepositoryException;

    protected abstract void initCopy(Node var1, Node var2) throws SyncNotSupportedException, CloudDriveException, RepositoryException;

    protected class ListenerSupport {
        Queue<CloudDriveListener> registry = new ConcurrentLinkedQueue<CloudDriveListener>();

        protected ListenerSupport() {
        }

        public void fireOnConnect(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onConnect(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onConnect listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnDisconnect(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onDisconnect(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onDisconnect listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnRemove(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onRemove(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onRemove listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnSynchronized(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onSynchronized(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onSynchronized listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnError(CloudDriveEvent event, Throwable error, String operationName) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onError(event, error, operationName);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onError listener about '" + error.getMessage() + "' during " + operationName + " in cloud drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnCreated(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onCreate(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onCreated listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }
    }

    public static interface FilesState {
        public Collection<String> getUpdating();

        public boolean isUpdating(String var1);

        public boolean isNew(String var1);
    }

    protected static interface CommandProgress {
        public long getComplete();

        public long getAvailable();

        public int getAttempts();
    }

    public static interface Command {
        public static final int COMPLETE = 100;

        public int getProgress();

        public boolean isDone();

        public long getStartTime();

        public long getFinishTime();

        public String getName();

        public boolean hasChanges();

        public Collection<CloudFile> getFiles();

        public Collection<String> getRemoved();

        public Collection<CloudDriveMessage> getMessages();

        public void await() throws ExecutionException, InterruptedException;
    }
}

