/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.GroupSettingTemplate;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingTemplateCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingTemplateCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingTemplateCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.GroupSettingTemplateRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IGroupSettingTemplateCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IGroupSettingTemplateCollectionRequest;

public class GroupSettingTemplateCollectionRequest
extends BaseCollectionRequest<GroupSettingTemplateCollectionResponse, IGroupSettingTemplateCollectionPage>
implements IGroupSettingTemplateCollectionRequest {
    public GroupSettingTemplateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupSettingTemplateCollectionResponse.class, IGroupSettingTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IGroupSettingTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(GroupSettingTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupSettingTemplateCollectionPage get() throws ClientException {
        GroupSettingTemplateCollectionResponse response = (GroupSettingTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(GroupSettingTemplate newGroupSettingTemplate, ICallback<GroupSettingTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupSettingTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSettingTemplate, callback);
    }

    @Override
    public GroupSettingTemplate post(GroupSettingTemplate newGroupSettingTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSettingTemplate);
    }

    @Override
    public IGroupSettingTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IGroupSettingTemplateCollectionPage buildFromResponse(GroupSettingTemplateCollectionResponse response) {
        GroupSettingTemplateCollectionRequestBuilder builder = response.nextLink != null ? new GroupSettingTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupSettingTemplateCollectionPage page = new GroupSettingTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

