/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.Version;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotContainBinaryFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsVersionableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionData;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionLog;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={CheckOutActionListener.class})})
public class CheckOutManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsNotCheckedOutFilter(), new IsVersionableFilter(), new IsNotTrashHomeNodeFilter(), new IsNotContainBinaryFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void checkOutManage(Event<? extends UIComponent> event, UIJCRExplorer uiExplorer, UIApplication uiApp) throws Exception {
        Object nodePath = event.getRequestContext().getRequestParameter("objectId");
        if (nodePath == null) {
            nodePath = uiExplorer.getCurrentWorkspace() + ":" + uiExplorer.getCurrentPath();
        }
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher((CharSequence)nodePath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + (String)nodePath + "'");
        }
        wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node node = uiExplorer.getNodeByPath((String)nodePath, session);
        nodePath = node.getPath();
        session = node.getSession();
        wsName = session.getWorkspace().getName();
        try {
            String userId = "";
            try {
                userId = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception e) {
                userId = node.getSession().getUserID();
            }
            Version liveVersion = node.getBaseVersion();
            node.checkout();
            String currentState = node.getProperty("publication:currentState").getString();
            VersionLog versionLog = new VersionLog(liveVersion.getName(), currentState, userId, (Calendar)new GregorianCalendar(), "UIPublicationHistory.create-version");
            Map<String, VersionData> revisionsMap = CheckOutManageComponent.getRevisionData(node);
            VersionData liveRevisionData = new VersionData(liveVersion.getUUID(), currentState, userId);
            revisionsMap.put(liveVersion.getUUID(), liveRevisionData);
            CheckOutManageComponent.addRevisionData(node, revisionsMap.values());
            CheckOutManageComponent.addLog(node, versionLog);
            node.save();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    private static void addLog(Node node, VersionLog versionLog) throws Exception {
        Value[] values = node.getProperty("publication:history").getValues();
        ValueFactory valueFactory = node.getSession().getValueFactory();
        ArrayList<Value> list = new ArrayList<Value>(Arrays.asList(values));
        list.add(valueFactory.createValue(versionLog.toString()));
        node.setProperty("publication:history", list.toArray(new Value[0]));
    }

    private static Map<String, VersionData> getRevisionData(Node node) throws Exception {
        HashMap<String, VersionData> map = new HashMap<String, VersionData>();
        try {
            for (Value v : node.getProperty("publication:revisionData").getValues()) {
                VersionData versionData = VersionData.toVersionData((String)v.getString());
                map.put(versionData.getUUID(), versionData);
            }
        }
        catch (Exception e) {
            return map;
        }
        return map;
    }

    private static void addRevisionData(Node node, Collection<VersionData> list) throws Exception {
        ArrayList<Value> valueList = new ArrayList<Value>();
        ValueFactory factory = node.getSession().getValueFactory();
        for (VersionData versionData : list) {
            valueList.add(factory.createValue(versionData.toStringValue()));
        }
        node.setProperty("publication:revisionData", valueList.toArray(new Value[0]));
    }

    public static class CheckOutActionListener
    extends UIWorkingAreaActionListener<CheckOutManageComponent> {
        public void processEvent(Event<CheckOutManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((CheckOutManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)((CheckOutManageComponent)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
            CheckOutManageComponent.checkOutManage(event, uiExplorer, uiApp);
        }
    }
}

