/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DomainDnsRecord;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DomainDnsRecordCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DomainDnsRecordCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DomainDnsRecordCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.DomainDnsRecordRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDomainDnsRecordCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDomainDnsRecordCollectionRequest;

public class DomainDnsRecordCollectionRequest
extends BaseCollectionRequest<DomainDnsRecordCollectionResponse, IDomainDnsRecordCollectionPage>
implements IDomainDnsRecordCollectionRequest {
    public DomainDnsRecordCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DomainDnsRecordCollectionResponse.class, IDomainDnsRecordCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDomainDnsRecordCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DomainDnsRecordCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDomainDnsRecordCollectionPage get() throws ClientException {
        DomainDnsRecordCollectionResponse response = (DomainDnsRecordCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DomainDnsRecord newDomainDnsRecord, ICallback<DomainDnsRecord> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DomainDnsRecordRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDomainDnsRecord, callback);
    }

    @Override
    public DomainDnsRecord post(DomainDnsRecord newDomainDnsRecord) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DomainDnsRecordRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDomainDnsRecord);
    }

    @Override
    public IDomainDnsRecordCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDomainDnsRecordCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDomainDnsRecordCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDomainDnsRecordCollectionPage buildFromResponse(DomainDnsRecordCollectionResponse response) {
        DomainDnsRecordCollectionRequestBuilder builder = response.nextLink != null ? new DomainDnsRecordCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DomainDnsRecordCollectionPage page = new DomainDnsRecordCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

