/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.fastcontentcreator;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCPortlet;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UIUploadInput;

@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})})
public class UIFCCForm
extends UIDialogForm
implements UISelectable {
    public static final String FIELD_TAXONOMY = "categories";
    public static final String POPUP_TAXONOMY = "UIPopupTaxonomy";
    private List<String> listTaxonomy = new ArrayList<String>();
    private List<String> listTaxonomyName = new ArrayList<String>();
    private String documentType_;
    private JCRResourceResolver jcrTemplateResourceResolver_;

    public UIFCCForm() throws Exception {
        PortletPreferences preferences = UIFCCUtils.getPortletPreferences();
        String custom_save_button = preferences.getValue("saveButton", "");
        this.setActions(new String[]{custom_save_button});
    }

    public String event(String name) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append("Save").append("',true)");
        return b.toString();
    }

    private String getFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            return ((PortletRequestContext)context).getWindowId() + "#" + this.getId();
        }
        return this.getId();
    }

    public List<String> getListTaxonomy() {
        return this.listTaxonomy;
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomy(List<String> listTaxonomyNew) {
        this.listTaxonomy = listTaxonomyNew;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            if (userName == null) {
                return templateService.getTemplatePathByAnonymous(true, this.documentType_);
            }
            return templateService.getTemplatePathByUser(true, this.documentType_, userName);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.documentType_};
            uiApp.addMessage(new ApplicationMessage("UIFCCForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value.toString());
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            String valueTaxonomy = String.valueOf(value).trim();
            List taxonomylist = inputSet.getValue();
            if (!taxonomylist.contains(valueTaxonomy)) {
                this.listTaxonomy.add(valueTaxonomy);
                this.listTaxonomyName.add(valueTaxonomy);
                taxonomylist.add(valueTaxonomy);
            }
            inputSet.setValue(taxonomylist);
        }
        UIFCCPortlet uiContainer = (UIFCCPortlet)this.getParent();
        uiContainer.removeChildById("PopupComponent");
    }

    public Node getCurrentNode() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        PortletPreferences preferences = UIFCCUtils.getPortletPreferences();
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(preferences.getValue("workspace", ""), repositoryService.getCurrentRepository());
        return (Node)session.getItem(preferences.getValue("path", ""));
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public boolean isEditing() {
        return false;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        if (this.jcrTemplateResourceResolver_ == null) {
            this.newJCRTemplateResourceResolver();
        }
        return this.jcrTemplateResourceResolver_;
    }

    public void newJCRTemplateResourceResolver() {
        try {
            this.jcrTemplateResourceResolver_ = new JCRResourceResolver(this.getDMSWorkspace());
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UIFCCForm.msg.new-jcr-template", null, (int)0);
        }
    }

    private String getDMSWorkspace() {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        return dmsConfiguration.getConfig().getSystemWorkspace();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().loadScriptResource("wcm-webui-extension");
        context.getJavascriptManager().addCustomizedOnLoadScript((CharSequence)"changeWarning();");
        super.processRender(context);
    }

    public static class RemoveActionListener
    extends EventListener<UIFCCForm> {
        public void execute(Event<UIFCCForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIFCCForm)((Object)event.getSource())).getParent());
        }
    }

    public static class AddActionListener
    extends EventListener<UIFCCForm> {
        public void execute(Event<UIFCCForm> event) throws Exception {
            UIFCCForm uiFCCForm = (UIFCCForm)((Object)event.getSource());
            UIFCCPortlet fastContentCreatorPortlet = (UIFCCPortlet)uiFCCForm.getParent();
            String clickedField = event.getRequestContext().getRequestParameter("objectId");
            if (uiFCCForm.isReference) {
                UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)uiFCCForm.getChildById(UIFCCForm.FIELD_TAXONOMY);
                if (uiSet != null && uiSet.getName() != null && uiSet.getName().equals(UIFCCForm.FIELD_TAXONOMY) && clickedField != null && clickedField.equals(UIFCCForm.FIELD_TAXONOMY)) {
                    NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiFCCForm.getApplicationComponent(NodeHierarchyCreator.class);
                    if (uiSet.getValue().size() == 0) {
                        uiSet.setValue(new ArrayList());
                    }
                    String workspaceName = uiFCCForm.getDMSWorkspace();
                    UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiFCCForm.createUIComponent(UIOneTaxonomySelector.class, null, null);
                    uiOneTaxonomySelector.setIsDisable(workspaceName, false);
                    String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
                    RepositoryService repositoryService = (RepositoryService)uiFCCForm.getApplicationComponent(RepositoryService.class);
                    SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
                    Session session = sessionProvider.getSession(workspaceName, repositoryService.getCurrentRepository());
                    Node rootTree = (Node)session.getItem(rootTreePath);
                    NodeIterator childrenIterator = rootTree.getNodes();
                    if (childrenIterator.hasNext()) {
                        Node childNode = childrenIterator.nextNode();
                        rootTreePath = childNode.getPath();
                    }
                    uiOneTaxonomySelector.setRootNodeLocation(uiFCCForm.repositoryName, workspaceName, rootTreePath);
                    uiOneTaxonomySelector.init(WCMCoreUtils.getUserSessionProvider());
                    String param = "returnField=categories";
                    uiOneTaxonomySelector.setSourceComponent((UIComponent)uiFCCForm, new String[]{param});
                    Utils.createPopupWindow((UIContainer)uiFCCForm, (UIComponent)uiOneTaxonomySelector, (String)"UIFCCTaxonomyPopupWindow", (int)640);
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)fastContentCreatorPortlet);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiFCCForm.getParent());
            }
        }
    }

    public static class RemoveReferenceActionListener
    extends EventListener<UIFCCForm> {
        public void execute(Event<UIFCCForm> event) throws Exception {
            UIFCCForm fastContentCreatorForm = (UIFCCForm)((Object)event.getSource());
            fastContentCreatorForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            fastContentCreatorForm.getUIStringInput(fieldName).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(fastContentCreatorForm.getParent());
        }
    }

    public static class ShowComponentActionListener
    extends EventListener<UIFCCForm> {
        public void execute(Event<UIFCCForm> event) throws Exception {
            String[] stringArray;
            UIFCCForm fastContentCreatorForm = (UIFCCForm)((Object)event.getSource());
            UIFCCPortlet fastContentCreatorPortlet = (UIFCCPortlet)fastContentCreatorForm.getParent();
            fastContentCreatorForm.isShowingComponent = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            Map fieldPropertiesMap = (Map)fastContentCreatorForm.componentSelectors.get(fieldName);
            String classPath = (String)fieldPropertiesMap.get("selectorClass");
            String rootPath = (String)fieldPropertiesMap.get("rootPath");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(classPath, true, cl);
            UIComponent component = fastContentCreatorPortlet.createUIComponent(clazz, null, null);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)fastContentCreatorForm.getApplicationComponent(NodeHierarchyCreator.class);
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            String selectorParams = (String)fieldPropertiesMap.get("selectorParams");
            if (component instanceof UIOneNodePathSelector) {
                String[] arrParams;
                String repositoryName = UIFCCUtils.getPreferenceRepository();
                String wsFieldName = (String)fieldPropertiesMap.get("workspaceField");
                String wsName = "";
                if (wsFieldName != null && wsFieldName.length() > 0) {
                    wsName = (String)((UIFormInputBase)fastContentCreatorForm.getUIInput(wsFieldName)).getValue();
                    ((UIOneNodePathSelector)component).setIsDisable(wsName, true);
                }
                if (selectorParams != null && (arrParams = selectorParams.split(",")).length == 4) {
                    ((UIOneNodePathSelector)component).setAcceptedNodeTypesInPathPanel(new String[]{"nt:file"});
                    wsName = arrParams[1];
                    rootPath = arrParams[2];
                    ((UIOneNodePathSelector)component).setIsDisable(wsName, true);
                    if (arrParams[3].indexOf(";") > -1) {
                        ((UIOneNodePathSelector)component).setAcceptedMimeTypes(arrParams[3].split(";"));
                    } else {
                        ((UIOneNodePathSelector)component).setAcceptedMimeTypes(new String[]{arrParams[3]});
                    }
                }
                if (rootPath == null) {
                    rootPath = "/";
                }
                ((UIOneNodePathSelector)component).setRootNodeLocation(repositoryName, wsName, rootPath);
                ((UIOneNodePathSelector)component).setShowRootPathSelect(true);
                ((UIOneNodePathSelector)component).init(sessionProvider);
            } else if (component instanceof UIOneTaxonomySelector) {
                String workspaceName = fastContentCreatorForm.getDMSWorkspace();
                ((UIOneTaxonomySelector)component).setIsDisable(workspaceName, false);
                String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
                RepositoryService repositoryService = (RepositoryService)fastContentCreatorForm.getApplicationComponent(RepositoryService.class);
                Session session = sessionProvider.getSession(workspaceName, repositoryService.getCurrentRepository());
                Node rootTree = (Node)session.getItem(rootTreePath);
                NodeIterator childrenIterator = rootTree.getNodes();
                if (childrenIterator.hasNext()) {
                    Node childNode = childrenIterator.nextNode();
                    rootTreePath = childNode.getPath();
                }
                ((UIOneTaxonomySelector)component).setRootNodeLocation(fastContentCreatorForm.repositoryName, workspaceName, rootTreePath);
                ((UIOneTaxonomySelector)component).init(sessionProvider);
            }
            Utils.createPopupWindow((UIContainer)fastContentCreatorForm, (UIComponent)component, (String)"UIFCCTaxonomyPopupWindow", (int)640);
            String param = "returnField=" + fieldName;
            if (selectorParams == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = param;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = param;
                stringArray = stringArray3;
                stringArray3[1] = "selectorParams=" + selectorParams;
            }
            String[] params = stringArray;
            ((ComponentSelector)component).setSourceComponent((UIComponent)fastContentCreatorForm, params);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)fastContentCreatorPortlet);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIFCCForm> {
        public void execute(Event<UIFCCForm> event) throws Exception {
            UIFormMultiValueInputSet uiSet;
            UIFCCForm fastContentCreatorForm = (UIFCCForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)fastContentCreatorForm.getAncestorOfType(UIApplication.class);
            PortletPreferences preferences = UIFCCUtils.getPortletPreferences();
            String preferencePath = preferences.getValue("path", "");
            String preferenceType = preferences.getValue("type", "");
            String preferenceWorkspace = preferences.getValue("workspace", "");
            RepositoryService repositoryService = (RepositoryService)fastContentCreatorForm.getApplicationComponent(RepositoryService.class);
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            Session session = sessionProvider.getSession(preferenceWorkspace, repositoryService.getCurrentRepository());
            CmsService cmsService = (CmsService)fastContentCreatorForm.getApplicationComponent(CmsService.class);
            TaxonomyService taxonomyService = (TaxonomyService)fastContentCreatorForm.getApplicationComponent(TaxonomyService.class);
            boolean hasCategories = false;
            StringBuffer sb = new StringBuffer();
            String categoriesPath = "";
            String[] categoriesPathList = null;
            List inputs = fastContentCreatorForm.getChildren();
            for (int i = 0; i < inputs.size(); ++i) {
                String[] valueName;
                UIFormInput input = (UIFormInput)inputs.get(i);
                if (input.getName() == null || !input.getName().equals("name") || org.exoplatform.ecm.webui.utils.Utils.isNameValid((String)(valueName = input.getValue().toString().trim()), (String[])org.exoplatform.ecm.webui.utils.Utils.SPECIALCHARACTER)) continue;
                uiApp.addMessage(new ApplicationMessage("UIFCCForm.msg.name-not-allowed", null, 1));
                return;
            }
            if (fastContentCreatorForm.isReference && (uiSet = (UIFormMultiValueInputSet)fastContentCreatorForm.getChild(UIFormMultiValueInputSet.class)) != null && uiSet.getName() != null && uiSet.getName().equals(UIFCCForm.FIELD_TAXONOMY)) {
                hasCategories = true;
                List listChildren = uiSet.getChildren();
                for (UIComponent component : listChildren) {
                    UIFormStringInput uiStringInput = (UIFormStringInput)component;
                    if (uiStringInput.getValue() == null) continue;
                    String string = ((String)uiStringInput.getValue()).trim();
                    sb.append(string).append(",");
                }
                categoriesPath = sb.toString();
                if (categoriesPath.endsWith(",")) {
                    categoriesPath = categoriesPath.substring(0, categoriesPath.length() - 1).trim();
                }
                if ((categoriesPathList = categoriesPath.split(",")) == null || categoriesPathList.length == 0) {
                    uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                    return;
                }
                for (String string : categoriesPathList) {
                    if (string == null || string.trim().length() <= 0 || string.indexOf("/") != -1) continue;
                    uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                    return;
                }
            }
            Map inputProperties = DialogFormUtil.prepareMap((List)fastContentCreatorForm.getChildren(), (Map)fastContentCreatorForm.getInputProperties(), (Map)fastContentCreatorForm.getInputOptions());
            Node homeNode = null;
            Node newNode = null;
            try {
                homeNode = (Node)session.getItem(preferencePath);
            }
            catch (AccessDeniedException ade) {
                Object[] args = new Object[]{preferencePath};
                uiApp.addMessage(new ApplicationMessage("UIFCCForm.msg.access-denied", args, 1));
                return;
            }
            catch (PathNotFoundException pnfe) {
                Object[] args = new Object[]{preferencePath};
                uiApp.addMessage(new ApplicationMessage("UIFCCForm.msg.path-not-found", args, 1));
                return;
            }
            try {
                String addedPath = cmsService.storeNode(preferenceType, homeNode, inputProperties, true);
                homeNode.getSession().save();
                int index = 0;
                if (homeNode.hasNode(addedPath.substring(addedPath.lastIndexOf("/") + 1))) {
                    newNode = homeNode.getNode(addedPath.substring(addedPath.lastIndexOf("/") + 1));
                    if (hasCategories && newNode != null && categoriesPath != null && categoriesPath.length() > 0) {
                        for (String categoryPath : categoriesPathList) {
                            index = categoryPath.indexOf("/");
                            taxonomyService.addCategory(newNode, categoryPath.substring(0, index), categoryPath.substring(index + 1));
                        }
                    }
                    event.getRequestContext().setAttribute("nodePath", (Object)newNode.getPath());
                }
                fastContentCreatorForm.reset();
                fastContentCreatorForm.setIsResetForm(true);
                for (UIComponent uiChild : fastContentCreatorForm.getChildren()) {
                    if (uiChild instanceof UIFormMultiValueInputSet) {
                        ((UIFormMultiValueInputSet)uiChild).setValue(new ArrayList());
                        continue;
                    }
                    if (!(uiChild instanceof UIUploadInput)) continue;
                    UploadService uploadService = (UploadService)fastContentCreatorForm.getApplicationComponent(UploadService.class);
                    uploadService.removeUploadResource(((UIUploadInput)uiChild).getUploadIds()[0]);
                }
                session.save();
                session.refresh(false);
                homeNode.getSession().refresh(false);
                boolean bl = Boolean.parseBoolean(preferences.getValue("isRedirect", ""));
                String preferenceRedirectPath = preferences.getValue("redirectPath", "");
                if (bl && preferenceRedirectPath != null) {
                    RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
                    requireJS.require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.ajaxRedirect('" + preferenceRedirectPath + "');");
                } else {
                    String saveMessage = preferences.getValue("saveMessage", "");
                    if (saveMessage == null) {
                        saveMessage = "saved-successfully";
                    }
                    Object[] args = new Object[]{saveMessage};
                    ApplicationMessage appMessage = new ApplicationMessage("UIFCCForm.msg.saved-successfully", args);
                    appMessage.setArgsLocalized(false);
                    uiApp.addMessage(appMessage);
                }
                event.getRequestContext().addUIComponentToUpdateByAjax(fastContentCreatorForm.getParent());
            }
            catch (AccessControlException ace) {
                throw new AccessDeniedException(ace.getMessage());
            }
            catch (VersionException ve) {
                uiApp.addMessage(new ApplicationMessage("UIFCCForm.msg.in-versioning", null, 1));
                return;
            }
            catch (AccessDeniedException e) {
                Object[] args = new Object[]{preferencePath};
                String string = "UIFCCForm.msg.access-denied";
                uiApp.addMessage(new ApplicationMessage(string, args, 1));
                return;
            }
            catch (LockException lock) {
                Object[] args = new Object[]{preferencePath};
                String string = "UIFCCForm.msg.node-locked";
                uiApp.addMessage(new ApplicationMessage(string, args, 1));
                return;
            }
            catch (ItemExistsException item) {
                Object[] args = new Object[]{preferencePath};
                String string = "UIFCCForm.msg.node-isExist";
                uiApp.addMessage(new ApplicationMessage(string, args, 1));
            }
        }
    }
}

