/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectone;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.tree.selectone.UISelectPathPanel;
import org.exoplatform.ecm.webui.tree.selectone.UITreeTaxonomyList;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/ecm/webui/tree/selectone/UISelectPathPanel.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UISelectTaxonomyPanel
extends UISelectPathPanel {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UISelectPathIterate");
    private static String TAXONOMY_TREE = "taxonomyTree";
    private String taxonomyTreePath = "";

    public String getTaxonomyTreePath() {
        return this.taxonomyTreePath;
    }

    public void setTaxonomyTreePath(String taxonomyTreePath) {
        this.taxonomyTreePath = taxonomyTreePath;
    }

    @Override
    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
    }

    @Override
    public String getDisplayName(Node node) throws RepositoryException {
        return ((UIOneTaxonomySelector)this.getAncestorOfType(UIOneTaxonomySelector.class)).getTaxonomyLabel(node);
    }

    public static class SelectActionListener
    extends EventListener<UISelectTaxonomyPanel> {
        public void execute(Event<UISelectTaxonomyPanel> event) throws Exception {
            UIPopupWindow uiPopupWindow;
            UISelectTaxonomyPanel uiSelectPathPanel = (UISelectTaxonomyPanel)((Object)event.getSource());
            UIOneTaxonomySelector uiTaxonomySelector = (UIOneTaxonomySelector)uiSelectPathPanel.getParent();
            UITreeTaxonomyList uiTreeList = (UITreeTaxonomyList)uiTaxonomySelector.getChild(UITreeTaxonomyList.class);
            UIContainer uiTreeSelector = (UIContainer)uiSelectPathPanel.getParent();
            String value = event.getRequestContext().getRequestParameter("objectId");
            String taxoTreeName = (String)uiTreeList.getUIFormSelectBox(TAXONOMY_TREE).getValue();
            Node taxoTreeNode = uiTaxonomySelector.getTaxoTreeNode(taxoTreeName);
            String taxoTreePath = taxoTreeNode.getPath();
            value = value.replace(taxoTreePath, taxoTreeName);
            if (uiTreeSelector instanceof UIOneNodePathSelector && !((UIOneNodePathSelector)uiTreeSelector).isDisable()) {
                StringBuffer sb = new StringBuffer();
                sb.append(((UIOneNodePathSelector)uiTreeSelector).getWorkspaceName()).append(":").append(value);
                value = sb.toString();
            }
            String returnField = ((UIBaseNodeTreeSelector)uiTreeSelector).getReturnFieldName();
            ((UISelectable)((UIBaseNodeTreeSelector)uiTreeSelector).getSourceComponent()).doSelect(returnField, value);
            if (uiTreeSelector instanceof UIOneNodePathSelector) {
                UIComponent component;
                uiPopupWindow = (UIPopupWindow)uiTreeSelector.getAncestorOfType(UIPopupWindow.class);
                if (uiPopupWindow != null) {
                    uiPopupWindow.setShow(false);
                    uiPopupWindow.setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupWindow);
                }
                if ((component = ((UIOneNodePathSelector)uiTreeSelector).getSourceComponent().getParent()) != null) {
                    event.getRequestContext().addUIComponentToUpdateByAjax(component);
                    return;
                }
            }
            if (uiTreeSelector instanceof UIOneTaxonomySelector) {
                UIComponent component;
                uiPopupWindow = (UIPopupWindow)uiTreeSelector.getAncestorOfType(UIPopupWindow.class);
                UIComponent parentOfUITreeSelector = uiTreeSelector.getParent();
                if (parentOfUITreeSelector instanceof UIPopupWindow || uiPopupWindow != null && ((UIContainer)parentOfUITreeSelector).getChildren().size() == 1) {
                    uiPopupWindow.setShow(false);
                    uiPopupWindow.setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupWindow);
                }
                if ((component = ((UIOneTaxonomySelector)uiTreeSelector).getSourceComponent().getParent()) != null) {
                    event.getRequestContext().addUIComponentToUpdateByAjax(component);
                }
            }
        }
    }
}

