/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.IRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;

public abstract class BaseRequestBuilder
implements IRequestBuilder {
    private final IBaseClient client;
    private final String requestUrl;
    private final List<Option> options = new ArrayList<Option>();

    public BaseRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> options) {
        this.requestUrl = requestUrl;
        this.client = client;
        if (options != null) {
            this.options.addAll(options);
        }
    }

    @Override
    public IBaseClient getClient() {
        return this.client;
    }

    @Override
    public String getRequestUrl() {
        return this.requestUrl;
    }

    public List<? extends Option> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    @Override
    public String getRequestUrlWithAdditionalSegment(String urlSegment) {
        return this.requestUrl + "/" + urlSegment;
    }

    public String getRequestUrlWithAdditionalParameter(String parameter) {
        return this.requestUrl + "('" + parameter + "')";
    }
}

