/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.TeamsApp;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ITeamsAppCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ITeamsAppCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsAppCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsAppCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsAppCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsAppRequestBuilder;

public class TeamsAppCollectionRequest
extends BaseCollectionRequest<TeamsAppCollectionResponse, ITeamsAppCollectionPage>
implements ITeamsAppCollectionRequest {
    public TeamsAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsAppCollectionResponse.class, ITeamsAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamsAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsAppCollectionPage get() throws ClientException {
        TeamsAppCollectionResponse response = (TeamsAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsApp newTeamsApp, ICallback<TeamsApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsApp, callback);
    }

    @Override
    public TeamsApp post(TeamsApp newTeamsApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsApp);
    }

    @Override
    public ITeamsAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITeamsAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ITeamsAppCollectionPage buildFromResponse(TeamsAppCollectionResponse response) {
        TeamsAppCollectionRequestBuilder builder = response.nextLink != null ? new TeamsAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsAppCollectionPage page = new TeamsAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

