/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.graphics.text.AbstractText;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.TextSelect;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordText
extends AbstractText
implements TextSelect {
    private static final Logger logger;
    public static int spaceFraction;
    private static boolean autoSpaceInsertion;
    private GlyphText currentGlyph;
    private ArrayList<GlyphText> glyphs;
    private StringBuilder text = new StringBuilder();
    private boolean isWhiteSpace;
    private int previousGlyphText;

    public WordText() {
        this.glyphs = new ArrayList(4);
    }

    public boolean isWhiteSpace() {
        return this.isWhiteSpace;
    }

    public void setWhiteSpace(boolean whiteSpace) {
        this.isWhiteSpace = whiteSpace;
    }

    protected boolean detectSpace(GlyphText sprite) {
        if (this.currentGlyph != null) {
            float tolerance;
            Rectangle2D.Float bounds1 = this.currentGlyph.getBounds();
            float spriteXCoord = sprite.getBounds().x;
            float space = Math.abs(spriteXCoord - (bounds1.x + bounds1.width));
            return space > (tolerance = bounds1.width / (float)spaceFraction);
        }
        return false;
    }

    protected static boolean detectPunctuation(GlyphText sprite, WordText currentWord) {
        String glyphText = sprite.getUnicode();
        if (glyphText != null && glyphText.length() > 0) {
            char c = glyphText.charAt(0);
            return WordText.isPunctuation(c) && !WordText.isDigit(currentWord);
        }
        return false;
    }

    protected static boolean detectWhiteSpace(GlyphText sprite) {
        String glyphText = sprite.getUnicode();
        if (glyphText != null && glyphText.length() > 0) {
            char c = glyphText.charAt(0);
            return WordText.isWhiteSpace(c);
        }
        return false;
    }

    public static boolean isPunctuation(int c) {
        return c == 46 || c == 44 || c == 63 || c == 33 || c == 58 || c == 59 || c == 34 || c == 39 || c == 47 || c == 92 || c == 96 || c == 35;
    }

    public static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10 || c == 12;
    }

    public static boolean isDigit(WordText currentWord) {
        if (currentWord != null) {
            int c = currentWord.getPreviousGlyphText();
            return WordText.isDigit((char)c);
        }
        return false;
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected WordText buildSpaceWord(GlyphText sprite) {
        Rectangle2D.Float spaceBounds;
        double offset;
        Rectangle2D.Float bounds1 = this.currentGlyph.getBounds();
        Rectangle2D.Float bounds2 = sprite.getBounds();
        float space = bounds2.x - (bounds1.x + bounds1.width);
        float maxWidth = Math.max(bounds1.width, bounds2.width) / 2.0f;
        int spaces = (int)(space / maxWidth);
        if (spaces == 0) {
            spaces = 1;
        }
        WordText whiteSpace = new WordText();
        Object spaceText = null;
        float spaceWidth = space / (float)spaces;
        boolean ltr = true;
        if (spaces > 0) {
            offset = bounds1.x + bounds1.width;
            spaceBounds = new Rectangle2D.Float(bounds1.x + bounds1.width, bounds1.y, spaceWidth, bounds1.height);
        } else {
            ltr = false;
            offset = bounds1.x - bounds1.width;
            spaces = 1;
            spaceBounds = new Rectangle2D.Float(this.bounds.x - spaceWidth, bounds1.y, spaceWidth, bounds1.height);
        }
        if (autoSpaceInsertion) {
            for (int i = 0; i < spaces && i < 50; ++i) {
                whiteSpace = this.autoSpaceCalculation(offset, spaceBounds, whiteSpace);
                if (ltr) {
                    spaceBounds.x += spaceBounds.width;
                    offset += (double)spaceWidth;
                    continue;
                }
                spaceBounds.x -= spaceBounds.width;
                offset -= (double)spaceWidth;
            }
        } else {
            whiteSpace = this.autoSpaceCalculation(offset, spaceBounds, whiteSpace);
        }
        return whiteSpace;
    }

    private WordText autoSpaceCalculation(double offset, Rectangle2D.Float spaceBounds, WordText whiteSpace) {
        GlyphText spaceText = new GlyphText((float)offset, this.currentGlyph.getY(), new Rectangle2D.Float(spaceBounds.x, spaceBounds.y, spaceBounds.width, spaceBounds.height), String.valueOf(' '), String.valueOf(' '));
        whiteSpace.addText(spaceText);
        whiteSpace.setWhiteSpace(true);
        return whiteSpace;
    }

    protected void addText(GlyphText sprite) {
        this.glyphs.add(sprite);
        this.currentGlyph = sprite;
        if (this.bounds == null) {
            Rectangle2D.Float rect = sprite.getBounds();
            this.bounds = new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
        } else {
            this.bounds.add(sprite.getBounds());
        }
        String unicode = sprite.getUnicode();
        this.previousGlyphText = unicode != null && unicode.length() > 0 ? (int)unicode.charAt(0) : 0;
        this.text.append(unicode);
    }

    @Override
    public Rectangle2D.Float getBounds() {
        if (this.bounds == null) {
            for (GlyphText glyph : this.glyphs) {
                if (this.bounds == null) {
                    this.bounds = new Rectangle2D.Float();
                    this.bounds.setRect(glyph.getBounds());
                    continue;
                }
                this.bounds.add(glyph.getBounds());
            }
        }
        return this.bounds;
    }

    public ArrayList<GlyphText> getGlyphs() {
        return this.glyphs;
    }

    @Override
    public StringBuilder getSelected() {
        StringBuilder selectedText = new StringBuilder();
        for (GlyphText glyph : this.glyphs) {
            if (!glyph.isSelected()) continue;
            selectedText.append(glyph.getUnicode());
        }
        return selectedText;
    }

    @Override
    public void clearHighlighted() {
        this.setHighlighted(false);
        this.setHasHighlight(false);
        for (GlyphText glyph : this.glyphs) {
            glyph.setHighlighted(false);
        }
    }

    @Override
    public void clearSelected() {
        this.setSelected(false);
        this.setHasSelected(false);
        for (GlyphText glyph : this.glyphs) {
            glyph.setSelected(false);
        }
    }

    @Override
    public void selectAll() {
        this.setSelected(true);
        this.setHasSelected(true);
        for (GlyphText glyph : this.glyphs) {
            glyph.setSelected(true);
        }
    }

    public String getText() {
        return this.text.toString();
    }

    public int getPreviousGlyphText() {
        return this.previousGlyphText;
    }

    public String toString() {
        return this.getText();
    }

    static {
        block5: {
            block4: {
                logger = Logger.getLogger(WordText.class.toString());
                try {
                    spaceFraction = Defs.sysPropertyInt("org.icepdf.core.views.page.text.spaceFraction", 3);
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading text space fraction");
                }
            }
            try {
                autoSpaceInsertion = Defs.sysPropertyBoolean("org.icepdf.core.views.page.text.autoSpace", true);
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading text text auto space detection");
            }
        }
    }
}

