/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.CloudDriveAccessException;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudFileAPI;
import org.exoplatform.services.cms.clouddrives.CloudUser;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotFoundException;
import org.exoplatform.services.cms.clouddrives.RefreshAccessException;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.cms.clouddrives.gdrive.GoogleDriveAPI;
import org.exoplatform.services.cms.clouddrives.gdrive.GoogleDriveConnector;
import org.exoplatform.services.cms.clouddrives.gdrive.GoogleDriveException;
import org.exoplatform.services.cms.clouddrives.gdrive.GoogleProvider;
import org.exoplatform.services.cms.clouddrives.gdrive.GoogleUser;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.InputStreamContent;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.util.DateTime;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.services.drive.model.About;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.services.drive.model.Change;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.services.drive.model.ChildReference;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.services.drive.model.File;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.services.drive.model.ParentReference;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.services.drive.model.User;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudDrive;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudFile;
import org.exoplatform.services.cms.clouddrives.jcr.NodeFinder;
import org.exoplatform.services.cms.clouddrives.oauth2.UserToken;
import org.exoplatform.services.cms.clouddrives.oauth2.UserTokenRefreshListener;
import org.exoplatform.services.cms.clouddrives.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalGoogleDrive
extends JCRLocalCloudDrive
implements UserTokenRefreshListener {
    protected JCRLocalGoogleDrive(GoogleUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws CloudDriveException, RepositoryException {
        super((CloudUser)user, driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
    }

    protected JCRLocalGoogleDrive(GoogleDriveConnector.API apiBuilder, GoogleProvider provider, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws RepositoryException, GoogleDriveException, CloudDriveException {
        super((CloudUser)JCRLocalGoogleDrive.loadUser(apiBuilder, provider, driveNode), driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
    }

    protected static GoogleUser loadUser(GoogleDriveConnector.API apiBuilder, GoogleProvider provider, Node driveNode) throws RepositoryException, GoogleDriveException, CloudDriveException {
        String refreshToken;
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("gdrive:oauth2AccessToken").getString();
        try {
            refreshToken = driveNode.getProperty("gdrive:oauth2RefreshToken").getString();
        }
        catch (PathNotFoundException e) {
            refreshToken = null;
        }
        long expirationTime = driveNode.getProperty("gdrive:oauth2TokenExpirationTime").getLong();
        GoogleDriveAPI driveAPI = apiBuilder.load(userId, refreshToken, accessToken, expirationTime).build();
        return new GoogleUser(userId, username, email, provider, driveAPI);
    }

    public GoogleUser getUser() {
        return (GoogleUser)this.user;
    }

    public void onUserTokenRefresh(UserToken token) throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                driveNode.setProperty("gdrive:oauth2AccessToken", token.getAccessToken());
                driveNode.setProperty("gdrive:oauth2RefreshToken", token.getRefreshToken());
                driveNode.setProperty("gdrive:oauth2TokenExpirationTime", token.getExpirationTime().longValue());
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error updating access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    public void onUserTokenRemove() throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                if (driveNode.hasProperty("gdrive:oauth2AccessToken")) {
                    driveNode.getProperty("gdrive:oauth2AccessToken").remove();
                }
                if (driveNode.hasProperty("gdrive:oauth2RefreshToken")) {
                    driveNode.getProperty("gdrive:oauth2RefreshToken").remove();
                }
                if (driveNode.hasProperty("gdrive:oauth2TokenExpirationTime")) {
                    driveNode.getProperty("gdrive:oauth2TokenExpirationTime").remove();
                }
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error removing access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    protected void refreshAccess() throws GoogleDriveException, RefreshAccessException {
        this.getUser().api().refreshAccess();
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        block10: {
            this.getUser().api().updateToken(((GoogleUser)newUser).api().getToken());
            try {
                boolean updateScopes;
                Node driveNode = this.rootNode();
                try {
                    updateScopes = !GoogleDriveAPI.SCOPES_STRING.equals(driveNode.getProperty("gdrive:scopes").getString());
                }
                catch (PathNotFoundException e) {
                    updateScopes = true;
                }
                if (!updateScopes) break block10;
                this.jcrListener.disable();
                try {
                    driveNode.setProperty("gdrive:scopes", GoogleDriveAPI.SCOPES_STRING);
                    driveNode.save();
                }
                catch (RepositoryException e) {
                    this.rollback(driveNode);
                    throw new CloudDriveException("Error updating access scopes: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    this.jcrListener.enable();
                }
            }
            catch (DriveRemovedException e) {
                throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean isAccessScopeMatch() throws RepositoryException, DriveRemovedException {
        Node driveNode = this.rootNode();
        try {
            return GoogleDriveAPI.SCOPES_STRING.equals(driveNode.getProperty("gdrive:scopes").getString());
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    protected boolean checkAccessScope(CloudDriveAccessException cause) throws RepositoryException, RefreshAccessException, DriveRemovedException {
        if (cause != null && !this.isAccessScopeMatch()) {
            throw new RefreshAccessException("Renew access key to Google Drive", (Throwable)cause);
        }
        return false;
    }

    protected Long readChangeId() throws RepositoryException, CloudDriveException {
        try {
            return this.rootNode().getProperty("gdrive:largestChangeId").getLong();
        }
        catch (PathNotFoundException e) {
            throw new CloudDriveException("Change id not found for the drive " + this.title());
        }
    }

    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
        Node driveNode = this.rootNode();
        driveNode.setProperty("gdrive:largestChangeId", id.longValue());
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        About about = this.getUser().api().about();
        driveNode.setProperty("ecd:id", about.getRootFolderId());
        driveNode.setProperty("ecd:url", about.getSelfLink());
        driveNode.setProperty("gdrive:scopes", GoogleDriveAPI.SCOPES_STRING);
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new Sync();
    }

    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected List<ParentReference> mergeParents(String parentId, List<ParentReference> cloudParents, Collection<String> localParentIds) {
        ArrayList<ParentReference> parents = new ArrayList<ParentReference>();
        if (cloudParents != null) {
            for (ParentReference cp : cloudParents) {
                String cpid = cp.getId();
                if (parentId.equals(cpid) || !localParentIds.contains(cpid)) continue;
                parents.add(cp);
            }
        }
        parents.add(new ParentReference().setId(parentId));
        return parents;
    }

    protected String editLink(String fileLink, String type, Node fileNode) throws RepositoryException {
        return this.isEditableType(type) ? fileLink : null;
    }

    protected long fileSize(File gf) {
        Long size = gf.getFileSize();
        if (size == null && (size = gf.getQuotaBytesUsed()) == null) {
            size = -1L;
        }
        return size;
    }

    protected boolean isEditableType(String mimeType) {
        return mimeType != null && mimeType.startsWith("application/vnd.google-apps.");
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        protected final GoogleDriveAPI api;

        FileAPI() {
            super((JCRLocalCloudDrive)JCRLocalGoogleDrive.this);
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        public CloudFile createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            File gf = new File();
            gf.setTitle(this.getTitle(fileNode));
            gf.setMimeType(mimeType);
            gf.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(fileNode))));
            gf.setCreatedDate(new DateTime(created.getTime()));
            gf.setModifiedDate(new DateTime(modified.getTime()));
            InputStreamContent fileContent = new InputStreamContent(mimeType, content);
            try {
                gf = this.api.insert(gf, fileContent);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
            long size = JCRLocalGoogleDrive.this.fileSize(gf);
            String link = gf.getAlternateLink();
            JCRLocalGoogleDrive.this.initFile(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified, size);
            return new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), link, JCRLocalGoogleDrive.this.isEditableType(gf.getMimeType()) ? link : null, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), null, gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, size, fileNode, true);
        }

        public CloudFile createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            File gf = new File();
            gf.setTitle(this.getTitle(folderNode));
            gf.setMimeType("application/vnd.google-apps.folder");
            gf.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(folderNode))));
            gf.setCreatedDate(new DateTime(created.getTime()));
            try {
                gf = this.api.insert(gf);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
            Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
            JCRLocalGoogleDrive.this.initFolder(folderNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
            return new JCRLocalCloudFile(folderNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), gf.getMimeType(), gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, folderNode, true);
        }

        public CloudFile updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
            String id = this.getId(fileNode);
            File gf = this.api.file(id);
            gf.setTitle(this.getTitle(fileNode));
            gf.setModifiedDate(new DateTime(modified.getTime()));
            gf.setParents(JCRLocalGoogleDrive.this.mergeParents(this.getParentId(fileNode), gf.getParents(), this.findParents(id)));
            try {
                this.api.update(gf);
                Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                long size = JCRLocalGoogleDrive.this.fileSize(gf);
                String link = gf.getAlternateLink();
                JCRLocalGoogleDrive.this.initFile(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified, size);
                return new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), link, JCRLocalGoogleDrive.this.isEditableType(gf.getMimeType()) ? link : null, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), null, gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, size, fileNode, true);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public CloudFile updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
            String id = this.getId(folderNode);
            File gf = this.api.file(id);
            gf.setTitle(this.getTitle(folderNode));
            gf.setModifiedDate(new DateTime(modified.getTime()));
            gf.setParents(JCRLocalGoogleDrive.this.mergeParents(this.getParentId(folderNode), gf.getParents(), this.findParents(id)));
            try {
                this.api.update(gf);
                Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                String link = gf.getAlternateLink();
                JCRLocalGoogleDrive.this.initFolder(folderNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                return new JCRLocalCloudFile(folderNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), gf.getMimeType(), gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, folderNode, true);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public CloudFile updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            File gf = this.api.file(this.getId(fileNode));
            gf.setMimeType(mimeType);
            gf.setModifiedDate(new DateTime(modified.getTime()));
            InputStreamContent fileContent = new InputStreamContent(mimeType, content);
            try {
                this.api.update(gf, fileContent);
                Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                long size = JCRLocalGoogleDrive.this.fileSize(gf);
                String link = gf.getAlternateLink();
                JCRLocalGoogleDrive.this.initFile(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified, size);
                return new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), link, JCRLocalGoogleDrive.this.isEditableType(gf.getMimeType()) ? link : null, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), null, gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, size, fileNode, true);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public CloudFile copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            File gf = new File();
            gf.setTitle(this.getTitle(destFileNode));
            gf.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(destFileNode))));
            try {
                gf = this.api.copy(this.getId(srcFileNode), gf);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
            Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
            long size = JCRLocalGoogleDrive.this.fileSize(gf);
            String link = gf.getAlternateLink();
            JCRLocalGoogleDrive.this.initFile(destFileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified, size);
            return new JCRLocalCloudFile(destFileNode.getPath(), gf.getId(), gf.getTitle(), link, JCRLocalGoogleDrive.this.isEditableType(gf.getMimeType()) ? link : null, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), null, gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, size, destFileNode, true);
        }

        public CloudFile copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            File gf = this.copySubtree(destFolderNode);
            return new JCRLocalCloudFile(destFolderNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), gf.getMimeType(), gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), this.getCreated(destFolderNode), this.getModified(destFolderNode), destFolderNode, true);
        }

        protected File copySubtree(Node folderNode) throws RepositoryException, GoogleDriveException, DriveRemovedException, CloudDriveAccessException, NotFoundException {
            File gfolder = new File();
            gfolder.setTitle(this.getTitle(folderNode));
            gfolder.setMimeType("application/vnd.google-apps.folder");
            gfolder.setParents(Arrays.asList(new ParentReference().setId(this.getParentId(folderNode))));
            gfolder.setModifiedDate(new DateTime(this.getModified(folderNode).getTime()));
            try {
                gfolder = this.api.insert(gfolder);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">> copySubtree folder " + folderNode.getPath() + " " + gfolder.getId()));
                }
                Calendar created = this.api.parseDate(gfolder.getCreatedDate().toStringRfc3339());
                Calendar modified = this.api.parseDate(gfolder.getModifiedDate().toStringRfc3339());
                JCRLocalGoogleDrive.this.initFolder(folderNode, gfolder.getId(), gfolder.getTitle(), gfolder.getMimeType(), gfolder.getAlternateLink(), gfolder.getOwnerNames().get(0), gfolder.getLastModifyingUserName(), created, modified);
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
            NodeIterator niter = folderNode.getNodes();
            while (niter.hasNext()) {
                Node node = niter.nextNode();
                if (!this.isFile(node)) continue;
                if (this.isFolder(node)) {
                    this.copySubtree(node);
                    continue;
                }
                File gfile = new File();
                gfile.setTitle(this.getTitle(node));
                gfile.setParents(Arrays.asList(new ParentReference().setId(gfolder.getId())));
                try {
                    String srcId = this.getId(node);
                    gfile = this.api.copy(srcId, gfile);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> copySubtree file " + node.getPath() + " " + srcId + " -> " + gfile.getId()));
                    }
                    Calendar created = this.api.parseDate(gfile.getCreatedDate().toStringRfc3339());
                    Calendar modified = this.api.parseDate(gfile.getModifiedDate().toStringRfc3339());
                    long size = JCRLocalGoogleDrive.this.fileSize(gfile);
                    String link = gfile.getAlternateLink();
                    JCRLocalGoogleDrive.this.initFile(node, gfile.getId(), gfile.getTitle(), gfile.getMimeType(), link, gfile.getEmbedLink(), gfile.getThumbnailLink(), gfile.getOwnerNames().get(0), gfile.getLastModifyingUserName(), created, modified, size);
                }
                catch (CloudDriveAccessException e) {
                    JCRLocalGoogleDrive.this.checkAccessScope(e);
                    throw e;
                }
            }
            return gfolder;
        }

        public boolean removeFile(String id) throws CloudDriveException, RepositoryException {
            try {
                this.api.delete(id);
                return true;
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean removeFolder(String id) throws CloudDriveException, RepositoryException {
            try {
                this.api.delete(id);
                return true;
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            try {
                File file = this.api.trash(id);
                return file.getLabels().getTrashed();
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            try {
                File file = this.api.trash(id);
                return file.getLabels().getTrashed();
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public CloudFile untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            try {
                File gf = this.api.untrash(this.getId(fileNode));
                if (!gf.getLabels().getTrashed().booleanValue()) {
                    Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                    Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                    long size = JCRLocalGoogleDrive.this.fileSize(gf);
                    String link = gf.getAlternateLink();
                    JCRLocalGoogleDrive.this.initFile(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified, size);
                    return new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), link, JCRLocalGoogleDrive.this.isEditableType(gf.getMimeType()) ? link : null, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), null, gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, size, fileNode, true);
                }
                return null;
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public CloudFile untrashFolder(Node folderNode) throws CloudDriveException, RepositoryException {
            try {
                File gf = this.api.untrash(this.getId(folderNode));
                if (!gf.getLabels().getTrashed().booleanValue()) {
                    Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                    Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                    String link = gf.getAlternateLink();
                    JCRLocalGoogleDrive.this.initFolder(folderNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    return new JCRLocalCloudFile(folderNode.getPath(), gf.getId(), gf.getTitle(), link, gf.getMimeType(), gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, folderNode, true);
                }
                return null;
            }
            catch (CloudDriveAccessException e) {
                JCRLocalGoogleDrive.this.checkAccessScope(e);
                throw e;
            }
        }

        public boolean isTrashSupported() {
            return true;
        }

        public CloudFile restore(String id, String path) throws NotFoundException, CloudDriveException, RepositoryException {
            throw new SyncNotSupportedException("Restore not supported");
        }
    }

    protected class Sync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final GoogleDriveAPI api;
        protected GoogleDriveAPI.ChangesIterator changes;
        protected Long lastChangeId;

        protected Sync() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalGoogleDrive.this);
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        protected void syncFiles() throws RepositoryException, CloudDriveException {
            long largestChangeId;
            this.lastChangeId = null;
            try {
                About about = this.api.about();
                largestChangeId = about.getLargestChangeId();
            }
            catch (CloudDriveAccessException e) {
                if (!JCRLocalGoogleDrive.this.isAccessScopeMatch()) {
                    throw new RefreshAccessException("Renew access key to Google Drive", (Throwable)e);
                }
                throw e;
            }
            long localChangeId = JCRLocalGoogleDrive.this.getChangeId();
            if (largestChangeId == localChangeId) {
                return;
            }
            long startChangeId = localChangeId + 1L;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Synchronizing changes from " + startChangeId + " to about " + largestChangeId));
            }
            this.changes = this.api.changes(startChangeId);
            this.iterators.add(this.changes);
            if (this.changes.hasNext()) {
                this.readLocalNodes();
                this.syncNext();
            }
            JCRLocalGoogleDrive.this.setChangeId(this.changes.getLargestChangeId());
        }

        protected void syncNext() throws RepositoryException, CloudDriveException {
            while (this.changes.hasNext() && !Thread.currentThread().isInterrupted()) {
                String[] parents;
                Change ch = (Change)this.changes.next();
                File gf = ch.getFile();
                if (ch.getDeleted().booleanValue() || (parents = this.getParents(gf)).length == 0) {
                    if (JCRLocalGoogleDrive.this.hasRemoved(ch.getFileId())) {
                        JCRLocalGoogleDrive.this.cleanRemoved(ch.getFileId());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(">> Returned file removal " + ch.getFileId() + " " + ch.getModificationDate().toStringRfc3339()));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> File removal " + ch.getFileId() + " " + ch.getModificationDate().toStringRfc3339()));
                    }
                    this.deleteFile(ch.getFileId());
                } else if (gf.getLabels().getTrashed().booleanValue()) {
                    if (JCRLocalGoogleDrive.this.hasRemoved(gf.getId())) {
                        JCRLocalGoogleDrive.this.cleanRemoved(gf.getId());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(">> Returned file trashing " + gf.getId() + " " + gf.getTitle() + " " + ch.getModificationDate().toStringRfc3339()));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> File trashing " + gf.getId() + " " + gf.getTitle() + " " + ch.getModificationDate().toStringRfc3339()));
                    }
                    this.deleteFile(gf.getId());
                } else if (JCRLocalGoogleDrive.this.hasUpdated(gf.getId())) {
                    JCRLocalGoogleDrive.this.cleanUpdated(gf.getId());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> Returned file update " + gf.getId() + " " + gf.getTitle() + " " + ch.getModificationDate().toStringRfc3339()));
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> File update " + gf.getId() + " " + gf.getTitle() + " " + ch.getModificationDate().toStringRfc3339()));
                    }
                    this.updateFile(gf, parents);
                }
                this.lastChangeId = ch.getId();
            }
        }

        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
            if (this.lastChangeId != null) {
                JCRLocalGoogleDrive.this.setChangeId(this.lastChangeId);
            }
        }

        protected void deleteFile(String fileId) throws RepositoryException, CloudDriveException {
            List existing = (List)this.nodes.remove(fileId);
            if (existing != null) {
                for (Node en : existing) {
                    this.removeLocalNode(en);
                }
            }
        }

        protected void updateFile(File gf, String[] parentIds) throws CloudDriveException, RepositoryException {
            ArrayList<Node> existing = (ArrayList<Node>)this.nodes.get(gf.getId());
            HashSet<Node> synced = new HashSet<Node>();
            boolean isFolder = this.api.isFolder(gf);
            for (String parentFileId : parentIds) {
                List fileParent = (List)this.nodes.get(parentFileId);
                if (fileParent == null) {
                    this.syncNext();
                    fileParent = (List)this.nodes.get(parentFileId);
                    if (fileParent == null) {
                        File gparent;
                        try {
                            gparent = this.api.file(parentFileId);
                        }
                        catch (NotFoundException e) {
                            continue;
                        }
                        if (this.isRemoved(gparent)) continue;
                        if (gf.getShared().booleanValue()) {
                            GoogleUser me = JCRLocalGoogleDrive.this.getUser();
                            boolean notMine = false;
                            List<User> parentOwners = gparent.getOwners();
                            if (parentOwners != null) {
                                for (User owner : parentOwners) {
                                    Object uo = owner.getUnknownKeys().get("emailAddress");
                                    if (uo != null && !me.getEmail().equals(uo)) {
                                        notMine = true;
                                        continue;
                                    }
                                    String userId = owner.getPermissionId();
                                    if (me.getId().equals(userId)) continue;
                                    notMine = true;
                                }
                                if (notMine) continue;
                            }
                        }
                        throw new CloudDriveException("Inconsistent changes: cannot find parent Node for '" + gf.getTitle() + "'");
                    }
                }
                for (Node fp : fileParent) {
                    JCRLocalCloudFile file;
                    Node fileNode = null;
                    Node fileNodeOther = null;
                    if (existing == null) {
                        existing = new ArrayList<Node>();
                        this.nodes.put(gf.getId(), existing);
                    } else {
                        for (Node n : existing) {
                            if (n.getParent().isSame((Item)fp)) {
                                fileNode = n;
                                continue;
                            }
                            if (fileNodeOther != null) continue;
                            fileNodeOther = n;
                        }
                    }
                    if (fileNode == null) {
                        if (fileNodeOther != null) {
                            if (parentIds.length > existing.size()) {
                                fileNode = JCRLocalGoogleDrive.this.copyFile(fileNodeOther, fp);
                            } else {
                                existing.remove(fileNodeOther);
                                fileNode = JCRLocalGoogleDrive.this.moveFile(gf.getId(), gf.getTitle(), fileNodeOther, fp);
                            }
                        } else {
                            fileNode = isFolder ? JCRLocalGoogleDrive.this.openFolder(gf.getId(), gf.getTitle(), fp) : JCRLocalGoogleDrive.this.openFile(gf.getId(), gf.getTitle(), fp);
                        }
                        existing.add(fileNode);
                    } else if (!JCRLocalGoogleDrive.this.fileAPI.getTitle(fileNode).equals(gf.getTitle())) {
                        fileNode = JCRLocalGoogleDrive.this.moveFile(gf.getId(), gf.getTitle(), fileNode, fp);
                    }
                    Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                    Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                    long size = JCRLocalGoogleDrive.this.fileSize(gf);
                    if (isFolder) {
                        JCRLocalGoogleDrive.this.initFolder(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                        file = new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), gf.getMimeType(), gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, fileNode, true);
                    } else {
                        JCRLocalGoogleDrive.this.initFile(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified, size);
                        file = new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), JCRLocalGoogleDrive.this.isEditableType(gf.getMimeType()) ? gf.getAlternateLink() : null, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), null, gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, size, fileNode, true);
                    }
                    synced.add(fileNode);
                    this.addChanged((CloudFile)file);
                }
            }
            if (existing != null) {
                for (Node n : existing) {
                    if (synced.contains(n)) continue;
                    this.removeLocalNode(n);
                }
            }
        }

        protected String[] getParents(File gfile) {
            List<ParentReference> parents;
            if (gfile != null && (parents = gfile.getParents()) != null) {
                String[] parentIds = new String[parents.size()];
                for (int i = 0; i < parents.size(); ++i) {
                    parentIds[i] = parents.get(i).getId();
                }
                return parentIds;
            }
            return new String[0];
        }

        protected boolean isRemoved(File gfile) throws GoogleDriveException {
            block5: {
                try {
                    if (gfile.getLabels().getTrashed().booleanValue()) {
                        return true;
                    }
                    List<ParentReference> parents = gfile.getParents();
                    if (parents.size() > 0) {
                        for (ParentReference p : parents) {
                            File gparent;
                            if (p.getIsRoot().booleanValue() || !this.isRemoved(gparent = this.api.file(p.getId()))) continue;
                            return true;
                        }
                        break block5;
                    }
                    return true;
                }
                catch (NotFoundException e) {
                    return true;
                }
            }
            return false;
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand {
        protected final GoogleDriveAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalGoogleDrive.this);
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            About about = this.api.about();
            String id = about.getRootFolderId();
            this.fetchChilds(id, this.driveNode);
            JCRLocalGoogleDrive.this.setChangeId(about.getLargestChangeId());
        }

        protected void fetchChilds(String fileId, Node localFile) throws CloudDriveException, RepositoryException {
            GoogleDriveAPI.ChildIterator children = this.api.children(fileId);
            this.iterators.add(children);
            while (children.hasNext() && !Thread.currentThread().isInterrupted()) {
                JCRLocalCloudFile file;
                Node fileNode;
                ChildReference child = (ChildReference)children.next();
                File gf = this.api.file(child.getId());
                if (gf.getLabels().getTrashed().booleanValue() || this.isConnected(fileId, gf.getId())) continue;
                boolean isFolder = this.api.isFolder(gf);
                DateTime createDate = gf.getCreatedDate();
                if (createDate == null) {
                    throw new GoogleDriveException("File " + gf.getTitle() + " doesn't have Created Date.");
                }
                Calendar created = this.api.parseDate(createDate.toStringRfc3339());
                DateTime modifiedDate = gf.getModifiedDate();
                if (modifiedDate == null) {
                    throw new GoogleDriveException("File " + gf.getTitle() + " doesn't have Modified Date.");
                }
                Calendar modified = this.api.parseDate(modifiedDate.toStringRfc3339());
                long size = JCRLocalGoogleDrive.this.fileSize(gf);
                String link = gf.getAlternateLink();
                if (isFolder) {
                    fileNode = JCRLocalGoogleDrive.this.openFolder(gf.getId(), gf.getTitle(), localFile);
                    JCRLocalGoogleDrive.this.initFolder(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    this.fetchChilds(gf.getId(), fileNode);
                    file = new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), gf.getMimeType(), gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, fileNode, true);
                } else {
                    fileNode = JCRLocalGoogleDrive.this.openFile(gf.getId(), gf.getTitle(), localFile);
                    JCRLocalGoogleDrive.this.initFile(fileNode, gf.getId(), gf.getTitle(), gf.getMimeType(), link, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified, size);
                    file = new JCRLocalCloudFile(fileNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), JCRLocalGoogleDrive.this.isEditableType(gf.getMimeType()) ? gf.getAlternateLink() : null, gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), null, gf.getLastModifyingUserName(), gf.getOwnerNames().get(0), created, modified, size, fileNode, true);
                }
                this.addConnected(fileId, (CloudFile)file);
            }
        }
    }
}

