/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.attachments.service.AttachmentEntityTypePlugin;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskService;

public class TaskAttachmentEntityTypePlugin
extends AttachmentEntityTypePlugin {
    private static final Log LOG = ExoLogger.getExoLogger(TaskAttachmentEntityTypePlugin.class);
    private final TaskService taskService;
    private final ProjectService projectService;
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final SessionProviderService sessionProviderService;
    private final RepositoryService repositoryService;
    public static final String DOCUMENTS_NODE = "Documents";
    private static final String DEFAULT_GROUPS_HOME_PATH = "/Groups";
    public static final String GROUPS_PATH_ALIAS = "groupsPath";

    public TaskAttachmentEntityTypePlugin(TaskService taskService, ProjectService projectService, NodeHierarchyCreator nodeHierarchyCreator, SessionProviderService sessionProviderService, RepositoryService repositoryService) {
        this.taskService = taskService;
        this.projectService = projectService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    public List<String> getlinkedAttachments(String entityType, long entityId, String attachmentId) {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        try {
            String sourceNodeId;
            Node originalNode;
            TaskDto task = this.taskService.getTask(entityId);
            Set taskPermittedIdentities = this.projectService.getParticipator(task.getStatus().getProject().getId());
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session userSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node attachmentNode = Utils.getNodeByIdentifier((Session)userSession, (String)attachmentId);
            if (attachmentNode == null) {
                return Collections.singletonList(attachmentId);
            }
            if (attachmentNode.isNodeType("exo:symlink") && (originalNode = Utils.getNodeByIdentifier((Session)userSession, (String)(sourceNodeId = attachmentNode.getProperty("exo:uuid").getString()))) != null) {
                attachmentNode = originalNode;
            }
            ArrayList<String> linkNodes = new ArrayList<String>();
            for (String permittedIdentity : taskPermittedIdentities) {
                if (permittedIdentity.contains(":/spaces/")) {
                    String groupId = permittedIdentity.split(":")[1];
                    if (attachmentNode.getPath().contains(groupId + "/") && !linkNodes.contains(attachmentId)) {
                        linkNodes.add(attachmentId);
                    } else {
                        Node linkNode;
                        Node parentNode;
                        Node rootNode = TaskAttachmentEntityTypePlugin.getGroupNode(this.nodeHierarchyCreator, userSession, groupId);
                        if (rootNode != null && !(parentNode = this.getDestinationFolder(rootNode, task.getId())).hasNode(attachmentNode.getName()) && (linkNode = Utils.createSymlink((Node)attachmentNode, (Node)parentNode, (String)permittedIdentity)) != null) {
                            linkNodes.add(((ExtendedNode)linkNode).getIdentifier());
                        }
                    }
                }
                if (attachmentNode.canAddMixin("exo:privilegeable")) {
                    attachmentNode.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)attachmentNode).setPermission(permittedIdentity, new String[]{"read"});
                attachmentNode.save();
            }
            return linkNodes;
        }
        catch (Exception e) {
            LOG.error("Error getting linked documents {}", new Object[]{attachmentId, e});
            return Collections.singletonList(attachmentId);
        }
    }

    public String getEntityType() {
        return "task";
    }

    private Node getDestinationFolder(Node rootNode, Long entityId) {
        try {
            Node parentNode;
            if (rootNode.hasNode("task")) {
                parentNode = rootNode.getNode("task");
            } else {
                parentNode = rootNode.addNode("task", "nt:folder");
                rootNode.save();
            }
            if (parentNode.hasNode(String.valueOf(entityId))) {
                return parentNode.getNode(String.valueOf(entityId));
            }
            Node taskNode = parentNode.addNode(String.valueOf(entityId), "nt:folder");
            parentNode.save();
            return taskNode;
        }
        catch (RepositoryException repositoryException) {
            LOG.error("Could not create and return parent folder for task {} under root folder {}", new Object[]{entityId, rootNode, repositoryException});
            return rootNode;
        }
    }

    private static Node getGroupNode(NodeHierarchyCreator nodeHierarchyCreator, Session session, String groupId) throws RepositoryException {
        String groupsHomePath = TaskAttachmentEntityTypePlugin.getGroupsPath(nodeHierarchyCreator);
        String groupPath = groupsHomePath + groupId + "/Documents";
        if (session.itemExists(groupPath)) {
            return (Node)session.getItem(groupPath);
        }
        return null;
    }

    private static String getGroupsPath(NodeHierarchyCreator nodeHierarchyCreator) {
        String groupsPath = nodeHierarchyCreator.getJcrPath(GROUPS_PATH_ALIAS);
        if (StringUtils.isBlank((CharSequence)groupsPath)) {
            groupsPath = DEFAULT_GROUPS_HOME_PATH;
        }
        return groupsPath;
    }
}

