/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.model.AttachmentContextEntity;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class Utils {
    private static final Log LOG = ExoLogger.getExoLogger(Utils.class);
    public static final String QUARANTINE_FOLDER = "Quarantine";
    public static final String EMPTY_STRING = "";
    public static final String EXO_SYMLINK_UUID = "exo:uuid";

    public static void sortAttachmentsByDate(List<AttachmentContextEntity> attachments) {
        attachments.sort((attachment1, attachment2) -> ObjectUtils.compare((Comparable)attachment2.getAttachedDate(), (Comparable)attachment1.getAttachedDate()));
    }

    public static Node getParentFolderNode(Session session, ManageDriveService manageDriveService, NodeHierarchyCreator nodeHierarchyCreator, NodeFinder nodeFinder, String driverName, String currentFolder) throws Exception {
        DriveData driveData = manageDriveService.getDriveByName(driverName);
        StringBuilder parentPath = new StringBuilder(EMPTY_STRING);
        if (driveData != null) {
            parentPath.append(driveData.getHomePath());
            if (driveData.getHomePath().startsWith(nodeHierarchyCreator.getJcrPath("usersPath") + "/${userId}")) {
                parentPath.setLength(0);
                parentPath.append(org.exoplatform.services.cms.impl.Utils.getPersonalDrivePath(driveData.getHomePath(), ConversationState.getCurrent().getIdentity().getUserId()));
            }
        }
        if (StringUtils.isNotBlank((String)currentFolder)) {
            parentPath.append("/").append(currentFolder);
        }
        String parentPathStr = parentPath.toString().replace("//", "/");
        return Utils.getTargetNode(session, nodeFinder, parentPathStr);
    }

    public static Node createSymlink(Node attachmentNode, Node parentNode, String permission) {
        try {
            Node linkNode = parentNode.addNode(attachmentNode.getName(), "exo:symlink");
            linkNode.setProperty("exo:workspace", attachmentNode.getSession().getWorkspace().getName());
            linkNode.setProperty("exo:primaryType", attachmentNode.getPrimaryNodeType().getName());
            linkNode.setProperty(EXO_SYMLINK_UUID, ((ExtendedNode)attachmentNode).getIdentifier());
            if (linkNode.canAddMixin("exo:sortable")) {
                linkNode.addMixin("exo:sortable");
            }
            if (attachmentNode.hasProperty("exo:title")) {
                linkNode.setProperty("exo:title", attachmentNode.getProperty("exo:title").getString());
            }
            linkNode.setProperty("exo:name", attachmentNode.getName());
            String nodeMimeType = Utils.getMimeType(attachmentNode);
            linkNode.addMixin("mix:fileType");
            linkNode.setProperty("exo:fileType", nodeMimeType);
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)linkNode).setPermission(permission, new String[]{"read"});
            parentNode.save();
            return linkNode;
        }
        catch (Exception e) {
            LOG.error("Error updating sharing of document {}", new Object[]{attachmentNode, e});
            return null;
        }
    }

    public static Node getTargetNode(Session session, NodeFinder nodeFinder, String path) throws Exception {
        return (Node)nodeFinder.getItem(session, path, true);
    }

    public static Session getSession(SessionProviderService sessionProviderService, RepositoryService repositoryService) throws RepositoryException {
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        return sessionProvider.getSession(Utils.getCurrentWorkspace(repositoryService), repositoryService.getCurrentRepository());
    }

    public static Session getSystemSession(SessionProviderService sessionProviderService, RepositoryService repositoryService) throws RepositoryException {
        SessionProvider sessionProvider = sessionProviderService.getSystemSessionProvider(null);
        return sessionProvider.getSession(Utils.getCurrentWorkspace(repositoryService), repositoryService.getCurrentRepository());
    }

    public static String getCurrentWorkspace(RepositoryService repositoryService) throws RepositoryException {
        return repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
    }

    public static boolean isQuarantinedItem(Session systemSession, String attachmentId) throws RepositoryException {
        Node attachmentNode = ((ExtendedSession)systemSession).getNodeByIdentifier(attachmentId);
        return attachmentNode.getPath().startsWith("/Quarantine/");
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return EMPTY_STRING;
    }

    public static List<Attachment> removeDuplicatedAttachments(Session userSession, List<Attachment> attachments) {
        HashMap<String, Attachment> filteringAttachmentsMap = new HashMap<String, Attachment>();
        for (Attachment entity : attachments) {
            Node entityNode = Utils.getNodeByIdentifier(userSession, entity.getId());
            try {
                if (entityNode != null && entityNode.isNodeType("exo:symlink")) {
                    String originalEntityNodeId = entityNode.getProperty(EXO_SYMLINK_UUID).getString();
                    filteringAttachmentsMap.put(originalEntityNodeId, entity);
                    continue;
                }
                filteringAttachmentsMap.put(entity.getId(), entity);
            }
            catch (Exception e) {
                filteringAttachmentsMap.put(entity.getId(), entity);
            }
        }
        return new ArrayList<Attachment>(filteringAttachmentsMap.values());
    }

    public static Node getNodeByIdentifier(Session session, String nodeId) {
        try {
            return ((ExtendedSession)session).getNodeByIdentifier(nodeId);
        }
        catch (PathNotFoundException e) {
            LOG.info("Node with identifier {} was not found !", new Object[]{nodeId});
        }
        catch (RepositoryException e) {
            LOG.debug("Error retrieving node with identifier {}", new Object[]{nodeId, e});
        }
        return null;
    }

    public static boolean isValidDocumentTitle(String name) {
        Pattern regex = Pattern.compile("[<\\\\>:\"/|?*]");
        Matcher matcher = regex.matcher(name);
        return !matcher.find();
    }
}

