/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import org.apache.commons.io.FileUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.impl.ThumbnailType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OfficeDocumentThumbnailPlugin
implements ComponentPlugin,
ThumbnailPlugin {
    private ThumbnailType config;
    private String description;
    private String name;
    private JodConverterService jodConverter_;
    private static final Log LOG = ExoLogger.getExoLogger((String)OfficeDocumentThumbnailPlugin.class.getName());

    public OfficeDocumentThumbnailPlugin(JodConverterService jodConverter, InitParams initParams) throws Exception {
        this.config = (ThumbnailType)initParams.getObjectParamValues(ThumbnailType.class).get(0);
        this.jodConverter_ = jodConverter;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public BufferedImage getBufferedImage(Node contentNode, String nodePath) throws Exception {
        if (contentNode.isNodeType("nt:resource")) {
            contentNode = contentNode.getParent();
        }
        String extension = null;
        if (contentNode.hasProperty("jcr:content/jcr:mimeType")) {
            String mimeType = contentNode.getProperty("jcr:content/jcr:mimeType").getString();
            extension = DMSMimeTypeResolver.getInstance().getExtension(mimeType);
        } else if (contentNode.getName().contains(".")) {
            String fileName = contentNode.getName();
            extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else {
            extension = ".officeDocument.tmp";
        }
        File in = File.createTempFile(this.name + "_tmp", "." + extension);
        InputStream documentStream = contentNode.getProperty("jcr:content/jcr:data").getStream();
        FileUtils.copyInputStreamToFile((InputStream)documentStream, (File)in);
        File out = File.createTempFile(this.name + "_tmp", ".jpg");
        boolean success = this.jodConverter_.convert(in, out, "jpg");
        if (success) {
            return ImageIO.read(out);
        }
        return null;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.config.getMimeTypes();
    }
}

