/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.cms.views.impl.ManageViewPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class CustomizeViewPlugin
extends ManageViewPlugin {
    protected static final String PROVIDER_SCOPE_NAME = "documents".intern();
    protected static final String BUTTON_IMPORTED_PATTERN = "documents.%s.%s.imported".intern();
    protected final InitParams params;
    protected final RepositoryService repositoryService;
    protected final NodeHierarchyCreator nodeHierarchyCreator;
    protected final ConfigurationManager cservice;
    protected final DMSConfiguration dmsConfiguration;
    protected final SettingService settingService;
    protected final TemplateService templateService;
    protected final Set<String> configuredTemplate = new HashSet<String>();
    protected final Set<String> configuredViews = new HashSet<String>();

    public CustomizeViewPlugin(RepositoryService repositoryService, InitParams params, ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration, TemplateService templateService, SettingService settingService) throws Exception {
        super(repositoryService, params, cservice, nodeHierarchyCreator, dmsConfiguration);
        this.params = params;
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.cservice = cservice;
        this.dmsConfiguration = dmsConfiguration;
        this.templateService = templateService;
        this.settingService = settingService;
    }

    @Override
    public Set<String> getConfiguredTemplates() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getConfiguredViews() {
        return Collections.emptySet();
    }

    @Override
    public void init() throws Exception {
        this.importCustomizedViews();
    }

    private void importCustomizedViews() throws Exception {
        this.configuredTemplate.clear();
        this.configuredViews.clear();
        Iterator objectsIter = this.params.getObjectParamIterator();
        String viewsPath = this.nodeHierarchyCreator.getJcrPath("userViewsPath");
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration.getConfig();
        Session session = manageableRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
        Node viewHomeNode = (Node)session.getItem(viewsPath);
        while (objectsIter.hasNext()) {
            ViewConfig viewObject;
            String viewNodeName;
            Object object = ((ObjectParameter)objectsIter.next()).getObject();
            if (!(object instanceof ViewConfig) || !viewHomeNode.hasNode(viewNodeName = (viewObject = (ViewConfig)object).getName())) continue;
            this.configuredViews.add(viewNodeName);
            Node viewNode = this.customizeView(viewHomeNode, viewNodeName, viewObject.getPermissions(), viewObject.isHideExplorerPanel(), viewObject.getTemplate());
            for (ViewConfig.Tab tab : viewObject.getTabList()) {
                this.customizeTab(viewNode, tab.getTabName(), tab.getButtons());
            }
        }
        session.save();
        session.logout();
    }

    protected Node customizeView(Node viewManager, String viewName, String permissions, Boolean hideExplorerPanel, String template) throws Exception {
        Node viewNode = viewManager.getNode(viewName);
        return viewNode;
    }

    protected void customizeTab(Node view, String tabName, String buttons) throws Exception {
        buttons = buttons.trim();
        if (view.hasNode(tabName) && buttons.length() > 0) {
            Node tab = view.getNode(tabName);
            LinkedHashSet<String> addButtons = new LinkedHashSet<String>();
            for (String action : buttons.split(";")) {
                if ((action = action.trim()).length() <= 0 || this.isImported(tabName, action)) continue;
                addButtons.add(action);
            }
            if (tab.hasProperty("exo:buttons")) {
                Property exoButtons = tab.getProperty("exo:buttons");
                if (addButtons.size() > 0) {
                    String newButtons = this.mergeButtons(exoButtons.getString(), addButtons);
                    exoButtons.setValue(newButtons);
                    addButtons.forEach(btn -> this.markAsImported(tabName, (String)btn));
                }
            }
            view.save();
        }
    }

    private void markAsImported(String tab, String action) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), String.format(BUTTON_IMPORTED_PATTERN, tab, action), SettingValue.create((Boolean)true));
    }

    private boolean isImported(String tab, String action) {
        SettingValue isViewCustomized = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), String.format(BUTTON_IMPORTED_PATTERN, tab, action));
        return isViewCustomized != null && Boolean.valueOf(isViewCustomized.getValue().toString()) != false;
    }

    protected String mergeButtons(String buttons, Set<String> addButtons) throws RepositoryException {
        StringBuilder buttonStr = new StringBuilder();
        for (String action : addButtons) {
            if (buttons.indexOf(action) >= 0) continue;
            if (buttonStr.length() > 0) {
                buttonStr.append(';');
                buttonStr.append(' ');
            }
            buttonStr.append(action);
        }
        if (buttonStr.length() > 0 && buttons.length() > 0) {
            buttonStr.append(';');
            buttonStr.append(' ');
        }
        buttonStr.append(buttons);
        return buttonStr.toString();
    }
}

