/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.liquibase;

import java.sql.CallableStatement;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class DropDuplicateAndNullAttachmentIds
implements CustomTaskChange {
    private String tableName;

    public String getConfirmationMessage() {
        return "Duplicate and null AttachmentId values dropped from table '" + this.tableName + "'";
    }

    public void execute(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        try {
            connection.attached(database);
            CallableStatement removeNullAttachmentIdStatement = connection.prepareCall("DELETE FROM " + this.tableName + " WHERE ATTACHMENT_ID = '';");
            removeNullAttachmentIdStatement.executeUpdate();
            CallableStatement removeDuplicateAttachmentIdStatement = connection.prepareCall(" DELETE FROM " + this.tableName + " AS A WHERE ATTACHMENTS_CONTEXT_ID NOT IN ( SELECT * FROM (SELECT MAX(ATTACHMENTS_CONTEXT_ID) FROM " + this.tableName + " AS B GROUP BY ATTACHMENT_ID,  ENTITY_ID,  ENTITY_TYPE) AS C);");
            removeDuplicateAttachmentIdStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception e) {
            throw new CustomChangeException("Error removing null and duplicate values from table " + this.tableName, (Throwable)e);
        }
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

