/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;

public class PortletTemplatePlugin
extends BaseComponentPlugin {
    private ConfigurationManager configurationManager;
    private InitParams initParams;
    private String portletName;

    public PortletTemplatePlugin(InitParams initParams, ConfigurationManager configurationManager) {
        this.initParams = initParams;
        this.configurationManager = configurationManager;
        this.portletName = this.initParams.getValueParam("portletName").getValue();
    }

    public String getPortletName() {
        return this.portletName;
    }

    public List<PortletTemplateConfig> getPortletTemplateConfigs() throws Exception {
        ArrayList<PortletTemplateConfig> list = new ArrayList<PortletTemplateConfig>();
        String configPath = this.initParams.getValueParam("portlet.template.path").getValue();
        Iterator iterator = this.initParams.getObjectParamIterator();
        while (iterator.hasNext()) {
            Object obj = ((ObjectParameter)iterator.next()).getObject();
            PortletTemplateConfig config = (PortletTemplateConfig)PortletTemplateConfig.class.cast(obj);
            String templateFile = configPath + "/" + config.getCategory() + "/" + config.getTemplateName();
            InputStream input = this.configurationManager.getInputStream(templateFile);
            String templateData = IOUtil.getStreamContentAsString((InputStream)input);
            config.setTemplateData(templateData);
            list.add(config);
        }
        return list;
    }

    public static class PortletTemplateConfig {
        private String category;
        private ArrayList<String> accessPermissions;
        private ArrayList<String> editPermissions;
        private String templateName;
        private String title;
        private String templateData;

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public ArrayList<String> getAccessPermissions() {
            return this.accessPermissions;
        }

        public void setAccessPermissions(ArrayList<String> accessPermissions) {
            this.accessPermissions = accessPermissions;
        }

        public ArrayList<String> getEditPermissions() {
            return this.editPermissions;
        }

        public void setEditPermissions(ArrayList<String> editPermissions) {
            this.editPermissions = editPermissions;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTemplateData() {
            return this.templateData;
        }

        public void setTemplateData(String templateData) {
            this.templateData = templateData;
        }
    }
}

