/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class NodeIdentifier {
    private String repository;
    private String workspace;
    private String uuid;

    public NodeIdentifier(String repository, String workspace, String uuid) {
        this.repository = repository;
        this.workspace = workspace;
        this.uuid = uuid;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public static final NodeIdentifier parse(String expr) {
        String[] temp = expr.split("::");
        if (temp.length == 3 && StringUtils.isNumeric((String)temp[2])) {
            return new NodeIdentifier(temp[0], temp[1], temp[2]);
        }
        return null;
    }

    public static final NodeIdentifier make(Node node) throws RepositoryException {
        Session session = node.getSession();
        String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        String workspace = session.getWorkspace().getName();
        String uuid = node.getUUID();
        return new NodeIdentifier(repository, workspace, uuid);
    }

    public static final String serialize(NodeIdentifier identifier) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(identifier.getRepository()).append("::").append(identifier.getWorkspace()).append("::").append(identifier.getUUID());
        return buffer.toString();
    }
}

