/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.auditing;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/auditing/UIAuditingInfo.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIAuditingInfo
extends UIContainer
implements UIPopupComponent {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "AuditingInfoIterator");
    private static final Log LOG = ExoLogger.getLogger((String)UIAuditingInfo.class.getName());

    public void activate() {
    }

    public void deActivate() {
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getListRecords() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid() throws Exception {
        ListAccessImpl recordList = new ListAccessImpl(AuditRecordData.class, this.getRecords());
        LazyPageList dataPageList = new LazyPageList((ListAccess)recordList, 10);
        this.uiPageIterator_.setPageList((PageList)dataPageList);
    }

    public List<AuditRecordData> getRecords() throws Exception {
        ArrayList<AuditRecordData> listRec;
        block4: {
            listRec = new ArrayList<AuditRecordData>();
            Node currentNode = this.getCurrentNode();
            try {
                AuditService auditService = (AuditService)this.getApplicationComponent(AuditService.class);
                if (Utils.isAuditable((Node)currentNode) && auditService.hasHistory(currentNode)) {
                    AuditHistory auHistory = auditService.getHistory(currentNode);
                    for (AuditRecord auditRecord : auHistory.getAuditRecords()) {
                        listRec.add(new AuditRecordData(auditRecord));
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return listRec;
    }

    public static class AuditRecordData {
        private String versionName_ = null;
        private String eventType_;
        private String userId_;
        private Calendar date_;

        public AuditRecordData(AuditRecord auditRecord) {
            this.versionName_ = auditRecord.getVersionName();
            this.eventType_ = String.valueOf(auditRecord.getEventType());
            this.userId_ = auditRecord.getUserId();
            this.date_ = auditRecord.getDate();
        }

        public String getVersionName() {
            return this.versionName_;
        }

        public void setVersionName(String versionName) {
            this.versionName_ = versionName;
        }

        public String getEventType() {
            return this.eventType_;
        }

        public void setEventType(String eventType) {
            this.eventType_ = eventType;
        }

        public String getUserId() {
            return this.userId_;
        }

        public void setUserId(String userId) {
            this.userId_ = userId;
        }

        public Calendar getDate() {
            return this.date_;
        }

        public void setDate(Calendar date) {
            this.date_ = date;
        }
    }

    public static class CloseActionListener
    extends EventListener<UIAuditingInfo> {
        public void execute(Event<UIAuditingInfo> event) throws Exception {
            UIAuditingInfo uiAuditingInfo = (UIAuditingInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAuditingInfo.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }
}

