/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.documents.VersionHistoryUtils;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;

public class FileindexingConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "file";
    private static final String FILE_METADATA_OBJECT_TYPE = "file";
    private static final int DEFAULT_MAX_FILE_SIZE_TO_INDEX = 10;
    private static final Log LOGGER = ExoLogger.getExoLogger(FileindexingConnector.class);
    private RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
    private TrashService trashService = (TrashService)CommonsUtils.getService(TrashService.class);
    private NewFolksonomyService newFolksonomyService = (NewFolksonomyService)CommonsUtils.getService(NewFolksonomyService.class);
    private MetadataService metadataService = (MetadataService)CommonsUtils.getService(MetadataService.class);
    private List<String> supportedContentIndexingMimetypes;
    private long contentMaxSizeToIndexInBytes;

    public FileindexingConnector(InitParams initParams) {
        super(initParams);
        if (initParams.containsKey((Object)"documents.content.indexing.mimetypes")) {
            String supportedMimetypes = initParams.getValueParam("documents.content.indexing.mimetypes").getValue();
            this.supportedContentIndexingMimetypes = Arrays.stream(StringUtils.split((String)supportedMimetypes, (String)",")).map(String::trim).collect(Collectors.toList());
        } else {
            this.supportedContentIndexingMimetypes = Collections.emptyList();
        }
        if (initParams.containsKey((Object)"documents.content.max.size.mb")) {
            String contentMaxSizeToIndex = initParams.getValueParam("documents.content.max.size.mb").getValue();
            this.contentMaxSizeToIndexInBytes = Long.parseLong(contentMaxSizeToIndex) * 1024L * 1024L;
        } else {
            this.contentMaxSizeToIndexInBytes = 0xA00000L;
        }
    }

    public boolean isNeedIngestPipeline() {
        return true;
    }

    public String getPipelineName() {
        return "file";
    }

    public String getConnectorName() {
        return "file";
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"repository\" : {\"type\" : \"keyword\"},\n").append("    \"workspace\" : {\"type\" : \"keyword\"},\n").append("    \"path\" : {\"type\" : \"keyword\"},\n").append("    \"author\" : {\"type\" : \"keyword\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"createdDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"activityId\" : {\"type\" : \"text\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"lastModifier\" : {\"type\" : \"text\"},\n").append("    \"fileType\" : {\"type\" : \"keyword\"},\n").append("    \"fileSize\" : {\"type\" : \"long\"},\n").append("    \"drive\" : {\"type\" : \"text\"},\n").append("    \"version\" : {\"type\" : \"long\"},\n").append("    \"name\" : {\"type\" : \"text\", \"analyzer\": \"letter_lowercase_asciifolding\"},\n").append("    \"title\":  { \"type\": \"text\", \"fields\": { \"raw\": { \"type\": \"keyword\" }, \"whitespace\": { \"type\": \"text\", \"analyzer\": \"whitespace_lowercase_asciifolding\" } }, \"index_options\": \"offsets\" },\n").append("    \"tags\" : {\"type\" : \"keyword\"},\n").append("    \"dc:title\" : {\"type\" : \"text\"},\n").append("    \"dc:creator\" : {\"type\" : \"text\"},\n").append("    \"dc:subject\" : {\"type\" : \"text\"},\n").append("    \"dc:description\" : {\"type\" : \"text\"},\n").append("    \"dc:publisher\" : {\"type\" : \"text\"},\n").append("    \"dc:contributor\" : {\"type\" : \"text\"},\n").append("    \"dc:date\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"dc:resourceType\" : {\"type\" : \"text\"},\n").append("    \"dc:format\" : {\"type\" : \"text\"},\n").append("    \"dc:identifier\" : {\"type\" : \"text\"},\n").append("    \"dc:source\" : {\"type\" : \"text\"},\n").append("    \"dc:language\" : {\"type\" : \"text\"},\n").append("    \"dc:relation\" : {\"type\" : \"text\"},\n").append("    \"dc:coverage\" : {\"type\" : \"text\"},\n").append("    \"dc:rights\" : {\"type\" : \"text\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    public String getAttachmentProcessor() {
        StringBuilder processors = new StringBuilder().append("{").append("  \"description\" : \"File processor\",\n").append("  \"processors\" : [{\n").append("    \"attachment\" : {\n").append("      \"field\" : \"file\",\n").append("      \"indexed_chars\" : -1,\n").append("      \"properties\" : [\"content\"]\n").append("    }\n").append("  },{\n").append("    \"remove\" : {\n").append("      \"field\" : \"file\"\n").append("    }\n").append("  }]\n").append("}");
        return processors.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document create(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        ExtendedSession session = null;
        try {
            Node node;
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", this.repositoryService.getCurrentRepository());
            try {
                node = session.getNodeByIdentifier(id);
            }
            catch (ItemNotFoundException e) {
                Document document = null;
                if (session != null) {
                    session.logout();
                }
                return document;
            }
            if (!node.isNodeType("nt:file") || this.trashService.isInTrash(node) || this.isInContentFolder(node)) {
                Document e = null;
                return e;
            }
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("name", node.getName());
            fields.put("repository", ((ManageableRepository)session.getRepository()).getConfiguration().getName());
            fields.put("workspace", session.getWorkspace().getName());
            fields.put("path", node.getPath());
            if (node.hasProperty("exo:title")) {
                fields.put("title", node.getProperty("exo:title").getString());
            } else {
                fields.put("title", node.getName());
            }
            if (node.hasProperty("exo:owner")) {
                fields.put("author", node.getProperty("exo:owner").getString());
            }
            if (node.hasProperty("jcr:created")) {
                fields.put("createdDate", String.valueOf(node.getProperty("jcr:created").getDate().getTimeInMillis()));
            }
            if (node.hasProperty("exo:lastModifiedDate")) {
                fields.put("lastUpdatedDate", String.valueOf(node.getProperty("exo:lastModifiedDate").getDate().getTimeInMillis()));
                fields.put("lastModifier", String.valueOf(node.getProperty("exo:lastModifier").getString()));
            } else {
                fields.put("lastUpdatedDate", (String)fields.get("createdDate"));
            }
            if (node.hasProperty("exo:activityId")) {
                fields.put("activityId", node.getProperty("exo:activityId").getString());
            }
            fields.put("version", String.valueOf(VersionHistoryUtils.getVersion((Node)node)));
            Node contentNode = node.getNode("jcr:content");
            if (contentNode != null) {
                boolean canIndexContent = false;
                if (contentNode.hasProperty("jcr:mimeType")) {
                    String mimeType = contentNode.getProperty("jcr:mimeType").getString();
                    canIndexContent = this.supportedContentIndexingMimetypes.stream().anyMatch(mimeType::matches);
                    fields.put("fileType", mimeType);
                }
                Property dataProperty = contentNode.getProperty("jcr:data");
                long fileSize = dataProperty.getLength();
                boolean bl = canIndexContent = canIndexContent && fileSize < this.contentMaxSizeToIndexInBytes;
                if (canIndexContent) {
                    InputStream fileStream = dataProperty.getStream();
                    byte[] fileBytes = IOUtils.toByteArray((InputStream)fileStream);
                    fields.put("file", Base64.getEncoder().encodeToString(fileBytes));
                    fields.put("fileSize", String.valueOf(fileBytes.length));
                } else {
                    fields.put("file", "");
                    fields.put("fileSize", String.valueOf(fileSize));
                }
                Map<String, String> dublinCoreMetadata = this.extractDublinCoreMetadata(contentNode);
                if (dublinCoreMetadata != null) {
                    fields.putAll(dublinCoreMetadata);
                }
            }
            LOGGER.info("ES document generated for file with id={} path=\"{}\"", new Object[]{id, node.getPath()});
            DocumentWithMetadata document = new DocumentWithMetadata();
            document.setId(id);
            document.setLastUpdatedDate(new Date());
            document.setPermissions(this.computePermissions(node));
            document.setTags(this.getTags(node, session.getWorkspace().getName()));
            document.setFields(fields);
            this.addDocumentMetadata(document, node.getUUID());
            DocumentWithMetadata documentWithMetadata = document;
            return documentWithMetadata;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while indexing file " + id), (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    private void addDocumentMetadata(DocumentWithMetadata document, String documentId) {
        MetadataObject metadataObject = new MetadataObject("file", documentId);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        document.setMetadataItems(metadataItems);
    }

    protected boolean isInContentFolder(Node node) {
        try {
            return node.isNodeType("exo:htmlFile") && Utils.isDocument((Node)node.getParent()) || node.isNodeType("exo:cssFile") && Utils.isDocument((Node)node.getParent().getParent()) || node.isNodeType("exo:jsFile") && Utils.isDocument((Node)node.getParent().getParent()) || node.isNodeType("nt:file") && (node.getPath().contains("/medias/images") || node.getPath().contains("/medias/videos") || node.getPath().contains("/medias/audio")) && Utils.isDocument((Node)node.getParent().getParent().getParent());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Document update(String id) {
        return this.create(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        ArrayList<String> allIds = new ArrayList<String>();
        try {
            Session session = WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", this.repositoryService.getCurrentRepository());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("select * from nt:file", "sql");
            QueryImpl queryImpl = (QueryImpl)query;
            queryImpl.setOffset((long)offset);
            queryImpl.setLimit((long)limit);
            QueryResult result = queryImpl.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                NodeImpl node = (NodeImpl)nodeIterator.nextNode();
                allIds.add(node.getInternalIdentifier());
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while fetching all nt:file nodes", e);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new IllegalStateException("Indexing queue processing interrupted");
        }
        LOGGER.info("Fetched {} files to push in indexing queue (offset={}, limit={})", new Object[]{allIds.size(), offset, limit});
        return allIds;
    }

    protected Map<String, String> extractDublinCoreMetadata(Node contentNode) throws RepositoryException {
        HashMap<String, String> dcFields = null;
        if (contentNode.isNodeType("dc:elementSet")) {
            PropertyDefinition[] dcPropertyDefinitions;
            dcFields = new HashMap<String, String>();
            ExtendedNodeTypeManager nodeTypeManager = this.repositoryService.getCurrentRepository().getNodeTypeManager();
            for (PropertyDefinition propertyDefinition : dcPropertyDefinitions = nodeTypeManager.getNodeType("dc:elementSet").getPropertyDefinitions()) {
                Property property;
                String propertyName = propertyDefinition.getName();
                if (!contentNode.hasProperty(propertyName) || (property = contentNode.getProperty(propertyName)) == null) continue;
                String strValue = null;
                if (propertyDefinition.isMultiple()) {
                    Value[] values = property.getValues();
                    if (values != null && values.length > 0) {
                        Value value = values[0];
                        strValue = property.getType() == 5 ? String.valueOf(value.getDate().toInstant().toEpochMilli()) : value.getString();
                    }
                } else {
                    strValue = property.getType() == 5 ? String.valueOf(property.getDate().toInstant().toEpochMilli()) : property.getString();
                }
                if (strValue == null) continue;
                dcFields.put(propertyName, strValue);
            }
        }
        return dcFields;
    }

    private Set<String> computePermissions(Node node) throws RepositoryException {
        HashSet<String> permissions = new HashSet<String>();
        AccessControlList acl = ((ExtendedNode)node).getACL();
        permissions.add(acl.getOwner());
        if (acl.getPermissionEntries() != null) {
            permissions.addAll(acl.getPermissionEntries().stream().map(AccessControlEntry::getIdentity).collect(Collectors.toSet()));
        }
        return permissions;
    }

    private List<String> getTags(Node node, String workspace) throws Exception {
        ArrayList<String> tags = new ArrayList<String>();
        List tagList = this.newFolksonomyService.getLinkedTagsOfDocument(node, workspace);
        for (Node nodeTag : tagList) {
            tags.add(nodeTag.getName());
        }
        return tags;
    }
}

