/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Row;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.DocumentProviderUtils;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.sidebar.TreeNode;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeNodePageIterator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.base.LazyPageList;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UITreeExplorer.gtmpl", events={@EventConfig(listeners={ExpandActionListener.class}, csrfCheck=false), @EventConfig(listeners={CollapseActionListener.class}, csrfCheck=false), @EventConfig(listeners={ExpandTreeActionListener.class}, csrfCheck=false)})
public class UITreeExplorer
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)UITreeExplorer.class.getName());
    private TreeNode treeRoot_;
    private String expandPath = null;
    private boolean isExpand = false;
    private CloudDriveService cloudDriveService = (CloudDriveService)CommonsUtils.getService(CloudDriveService.class);

    public UIRightClickPopupMenu getContextMenu() {
        return (UIRightClickPopupMenu)((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getChild(UIRightClickPopupMenu.class);
    }

    UIWorkingArea getWorkingArea() {
        return (UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class);
    }

    private UISideBar getSideBar() {
        return (UISideBar)this.getWorkingArea().findFirstComponentOfType(UISideBar.class);
    }

    UIComponent getCustomAction() throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomAction();
    }

    public TreeNode getRootTreeNode() {
        return this.treeRoot_;
    }

    public String getRootActionList() throws Exception {
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (!clipboardService.getClipboardList(userId, false).isEmpty()) {
            return this.getContextMenu().getJSOnclickShowPopup(uiExplorer.getCurrentDriveWorkspace() + ":" + uiExplorer.getRootPath(), "Paste").toString();
        }
        return "";
    }

    public boolean isDirectlyDrive() {
        PortletPreferences portletPref = ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).getPortletPreferences();
        String usecase = portletPref.getValue("usecase", "").trim();
        return !"selection".equals(usecase);
    }

    public String getDriveName() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData().getName();
    }

    public String getLabel() {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        DriveData driveData = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData();
        String id = driveData.getName();
        String path = driveData.getHomePath();
        Object driveLabelKey = "Drives.label." + id.replace(".", "").replace(" ", "");
        if ("User Documents".equals(id)) {
            String userId;
            driveLabelKey = "Drives.label.UserDocuments";
            String userDisplayName = "";
            String userIdPath = (String)driveData.getParameters().get("userId");
            String string = userId = userIdPath != null ? userIdPath.substring(userIdPath.lastIndexOf("/") + 1) : null;
            if (StringUtils.isNotEmpty(userId)) {
                userDisplayName = userId;
                User user = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getUserHandler().findUserByName(userId);
                if (user != null) {
                    userDisplayName = user.getDisplayName();
                }
            }
            try {
                return res.getString((String)driveLabelKey).replace("{0}", userDisplayName);
            }
            catch (MissingResourceException mre) {
                LOG.error((Object)("Cannot get resource string for " + (String)driveLabelKey));
            }
        } else {
            try {
                return res.getString((String)driveLabelKey);
            }
            catch (MissingResourceException ex) {
                CloudDrive cloudDrives = this.cloudDriveService.findDrive(driveData.getWorkspace(), driveData.getHomePath());
                if (cloudDrives != null) {
                    return cloudDrives.getTitle();
                }
                try {
                    RepositoryService repoService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
                    NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)CommonsUtils.getService(NodeHierarchyCreator.class);
                    String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
                    Node groupNode = (Node)WCMCoreUtils.getSystemSessionProvider().getSession(repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), repoService.getCurrentRepository()).getItem(groupPath + driveData.getName().replace(".", "/"));
                    return groupNode.getParent().getName() + " / " + groupNode.getProperty("exo:driveLabel").getString();
                }
                catch (Exception e) {
                    try {
                        return id.replace(".", " / ");
                    }
                    catch (RepositoryException e2) {
                        try {
                            LOG.warn((Object)("Cannot find clouddrive " + driveData.getHomePath() + " in " + driveData.getWorkspace()), (Throwable)e2);
                            return id.replace(".", " / ");
                        }
                        catch (Exception ex2) {
                            LOG.warn((Object)("Can not find resource string for " + (String)driveLabelKey), (Throwable)ex2);
                        }
                    }
                }
            }
        }
        return id.replace(".", " / ");
    }

    public boolean isAllowNodeTypesOnTree(Node node) throws RepositoryException {
        String[] arrayAllowNodeTypesOnTree;
        DriveData currentDrive = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData();
        String allowNodeTypesOnTree = currentDrive.getAllowNodeTypesOnTree();
        if (allowNodeTypesOnTree == null || allowNodeTypesOnTree.equals("*")) {
            return true;
        }
        for (String itemAllowNodeTypes : arrayAllowNodeTypesOnTree = allowNodeTypesOnTree.split(",")) {
            if (itemAllowNodeTypes.trim().length() <= 0 || !node.isNodeType(itemAllowNodeTypes.trim())) continue;
            return true;
        }
        return false;
    }

    public String getActionsList(Node node) throws Exception {
        if (node == null) {
            return "";
        }
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        try {
            NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
            nodeFinder.getItem(uiExplorer.getSession(), node.getPath());
            return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getActionsExtensionList(node);
        }
        catch (PathNotFoundException pne) {
            uiExplorer.refreshExplorerWithoutClosingPopup();
            return "";
        }
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomActions(node);
    }

    public boolean isPreferenceNode(Node node) {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).isPreferenceNode(node);
    }

    public List<TreeNode> getRenderedChildren(TreeNode treeNode) throws Exception {
        if (this.isPaginated(treeNode)) {
            UITreeNodePageIterator pageIterator = (UITreeNodePageIterator)this.findComponentById(treeNode.getPath());
            return pageIterator.getCurrentPageData();
        }
        if (this.isShowChildren(treeNode) && treeNode.getChildrenSize() > 0 && treeNode.getChildren().size() == 0) {
            UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            treeNode.setChildren(jcrExplorer.getChildrenList(treeNode.getPath(), false));
            return treeNode.getChildren();
        }
        return treeNode.getChildren();
    }

    public boolean isSystemWorkspace() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isSystemWorkspace();
    }

    public UITreeNodePageIterator getUIPageIterator(String id) throws Exception {
        return (UITreeNodePageIterator)this.findComponentById(id);
    }

    public boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    public boolean isPaginated(TreeNode treeNode) {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        int nodePerPages = jcrExplorer.getPreference().getNodesPerPage();
        return treeNode.getChildrenSize() > nodePerPages && this.findComponentById(treeNode.getPath()) != null;
    }

    public String getPortalName() {
        PortalContainerInfo containerInfo = (PortalContainerInfo)WCMCoreUtils.getService(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getServerPath() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public boolean isShowChildren(TreeNode treeNode) {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String currentPath = jcrExplorer.getCurrentPath();
        return treeNode.isExpanded() || currentPath.startsWith(treeNode.getPath());
    }

    public String getRepository() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String getEncodeCurrentPath() {
        return UITreeExplorer.encodeBase64(((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentPath());
    }

    public String getEncodeExpandPath() {
        if (this.expandPath != null) {
            return UITreeExplorer.encodeBase64(this.expandPath);
        }
        return null;
    }

    public boolean getIsExpand() {
        return this.isExpand;
    }

    public static String encodeBase64(String value) {
        value = value == null ? "" : value;
        return Base64.encode((byte[])value.getBytes()).replaceAll("\n", "");
    }

    private void addTreeNodePageIteratorAsChild(String id, PageList<TreeNode> pageList, String selectedPath, String currentPath) throws Exception {
        if (this.findComponentById(id) == null) {
            UITreeNodePageIterator nodePageIterator = (UITreeNodePageIterator)this.addChild(UITreeNodePageIterator.class, null, id);
            nodePageIterator.setPageList(pageList);
            nodePageIterator.setSelectedPath(selectedPath);
        } else {
            UITreeNodePageIterator existedComponent = (UITreeNodePageIterator)this.findComponentById(id);
            int currentPage = existedComponent.getCurrentPage();
            existedComponent.setPageList(pageList);
            if (!selectedPath.equalsIgnoreCase(currentPath) && currentPage <= existedComponent.getAvailablePage()) {
                existedComponent.setCurrentPage(currentPage);
            }
        }
    }

    private Node getRootNode() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getRootNode();
    }

    private void buildTree(String path) throws Exception {
        if (this.getSideBar() == null || !this.getSideBar().isRenderComponent("Explorer")) {
            return;
        }
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        int nodePerPages = jcrExplorer.getPreference().getNodesPerPage();
        TreeNode treeRoot = new TreeNode(this.getRootNode());
        if (path == null) {
            path = jcrExplorer.getCurrentPath();
        }
        String[] arr = path.replaceFirst(treeRoot.getPath(), "").split("/");
        TreeNode temp = treeRoot;
        StringBuffer subPath = null;
        String rootPath = treeRoot.getPath();
        StringBuffer prefix = new StringBuffer(rootPath);
        if (!rootPath.equals("/")) {
            prefix.append("/");
        }
        HashSet<String> emptySet = new HashSet<String>();
        if (temp.getChildrenSize() > nodePerPages) {
            LazyPageList<TreeNode> pageList = DocumentProviderUtils.getInstance().getPageList(jcrExplorer.getWorkspaceName(), rootPath, jcrExplorer.getPreference(), emptySet, emptySet, new TreeNodeDataCreater());
            this.addTreeNodePageIteratorAsChild(treeRoot.getPath(), (PageList<TreeNode>)pageList, rootPath, path);
        } else {
            temp.setChildren(jcrExplorer.getChildrenList(rootPath, false));
        }
        for (String nodeName : arr) {
            if (nodeName.length() == 0) continue;
            if ((temp = temp.getChildByName(nodeName)) == null) {
                this.treeRoot_ = treeRoot;
                return;
            }
            if (subPath == null) {
                subPath = new StringBuffer();
                subPath.append(prefix).append(nodeName);
            } else {
                subPath.append("/").append(nodeName);
            }
            if (temp.getChildrenSize() > nodePerPages) {
                LazyPageList<TreeNode> pageList = DocumentProviderUtils.getInstance().getPageList(jcrExplorer.getWorkspaceName(), subPath.toString(), jcrExplorer.getPreference(), emptySet, emptySet, new TreeNodeDataCreater());
                temp.setExpanded(this.isExpand);
                this.addTreeNodePageIteratorAsChild(temp.getPath(), (PageList<TreeNode>)pageList, subPath.toString(), path);
                continue;
            }
            temp.setChildren(jcrExplorer.getChildrenList(subPath.toString(), false));
        }
        this.treeRoot_ = treeRoot;
    }

    public void buildTree() throws Exception {
        this.buildTree(null);
    }

    public boolean isDocumentNodeType(Node node) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.isManagedNodeType(node.getPrimaryNodeType().getName());
    }

    public String getSelectedPath() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return UITreeExplorer.encodeBase64(uiExplorer.getCurrentPath());
    }

    private static boolean isInTrash(Item item) throws RepositoryException {
        return item instanceof Node && Utils.isInTrash((Node)((Node)item));
    }

    public boolean hasChildNode(Node node) throws Exception {
        if (!node.hasNodes()) {
            return false;
        }
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Preference preferences = uiExplorer.getPreference();
        if (!(this.isFolderType(node) || preferences.isJcrEnable() || node.isNodeType("exo:taxonomy"))) {
            return false;
        }
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            Node tmpNode = iterator.nextNode();
            if (!preferences.isShowHiddenNode() && !preferences.isShowNonDocumentType()) {
                if (tmpNode.isNodeType("exo:hiddenable") || !this.isDocumentOrFolderType(tmpNode)) continue;
                return true;
            }
            if (preferences.isShowHiddenNode() && !preferences.isShowNonDocumentType()) {
                if (!this.isDocumentOrFolderType(tmpNode)) continue;
                return true;
            }
            if (!preferences.isShowHiddenNode() && preferences.isShowNonDocumentType()) {
                if (tmpNode.isNodeType("exo:hiddenable")) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isDocumentOrFolderType(Node node) throws Exception {
        if (node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured")) {
            return true;
        }
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeType nodeType = node.getPrimaryNodeType();
        return templateService.getDocumentTemplates().contains(nodeType.getName());
    }

    private boolean isFolderType(Node node) throws Exception {
        return node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured");
    }

    private class TreeNodeDataCreater
    implements SearchDataCreator<TreeNode> {
        private TreeNodeDataCreater() {
        }

        public TreeNode createData(Node node, Row row, SearchResult searchResult) {
            try {
                return new TreeNode(node);
            }
            catch (RepositoryException e) {
                return null;
            }
        }
    }

    public static class CollapseActionListener
    extends EventListener<UITreeExplorer> {
        public void execute(Event<UITreeExplorer> event) throws Exception {
            UITreeExplorer treeExplorer = (UITreeExplorer)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)treeExplorer.getAncestorOfType(UIApplication.class);
            try {
                String path = event.getRequestContext().getRequestParameter("objectId");
                UIJCRExplorer uiExplorer = (UIJCRExplorer)treeExplorer.getAncestorOfType(UIJCRExplorer.class);
                path = LinkUtils.getParentPath((String)path);
                uiExplorer.setSelectNode(path);
                uiExplorer.updateAjax(event);
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class ExpandTreeActionListener
    extends EventListener<UITreeExplorer> {
        public void execute(Event<UITreeExplorer> event) throws Exception {
            String path;
            UITreeExplorer uiTreeExplorer = (UITreeExplorer)((Object)event.getSource());
            uiTreeExplorer.expandPath = path = event.getRequestContext().getRequestParameter("objectId");
            uiTreeExplorer.isExpand = true;
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTreeExplorer.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiTreeExplorer.getAncestorOfType(UIApplication.class);
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Item item = null;
            try {
                Session session = uiExplorer.getSessionByWorkspace(workspaceName);
                NodeFinder nodeFinder = (NodeFinder)uiTreeExplorer.getApplicationComponent(NodeFinder.class);
                item = nodeFinder.getItem(session, path);
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                return;
            }
            catch (ItemNotFoundException inf) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            if (UITreeExplorer.isInTrash(item)) {
                return;
            }
            if (uiExplorer.getPreference().isShowSideBar() && ((UIJCRExplorerPortlet)uiExplorer.getAncestorOfType(UIJCRExplorerPortlet.class)).isShowSideBar()) {
                uiTreeExplorer.buildTree(path);
            }
        }
    }

    public static class ExpandActionListener
    extends EventListener<UITreeExplorer> {
        public void execute(Event<UITreeExplorer> event) throws Exception {
            UITreeExplorer uiTreeExplorer = (UITreeExplorer)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            uiTreeExplorer.isExpand = false;
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTreeExplorer.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiTreeExplorer.getAncestorOfType(UIApplication.class);
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Item item = null;
            try {
                Session session = uiExplorer.getSessionByWorkspace(workspaceName);
                NodeFinder nodeFinder = (NodeFinder)uiTreeExplorer.getApplicationComponent(NodeFinder.class);
                item = nodeFinder.getItem(session, path);
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                return;
            }
            catch (ItemNotFoundException inf) {
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.path-not-found", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UITreeExplorer.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            if (UITreeExplorer.isInTrash(item)) {
                return;
            }
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
            if (!uiDocumentWorkspace.isRendered()) {
                ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                uiDocumentWorkspace.setRendered(true);
            } else {
                uiDocumentWorkspace.setRenderedChild(UIDocumentContainer.class);
            }
            uiExplorer.setSelectNode(workspaceName, path);
            UIPageIterator contentPageIterator = (UIPageIterator)uiExplorer.findComponentById("ContentPageIterator");
            if (contentPageIterator != null) {
                contentPageIterator.setCurrentPage(1);
            }
            uiExplorer.updateAjax(event);
            event.getRequestContext().getJavascriptManager().require("SHARED/multiUpload", "multiUpload").addScripts("multiUpload.setLocation('" + uiExplorer.getWorkspaceName() + "','" + uiExplorer.getDriveData().getName() + "','" + uiTreeExplorer.getLabel() + "','" + uiExplorer.getCurrentPath() + "','" + Utils.getPersonalDrivePath((String)uiExplorer.getDriveData().getHomePath(), (String)ConversationState.getCurrent().getIdentity().getUserId()) + "', '" + autoVersionService.isVersionSupport(uiExplorer.getCurrentPath(), uiExplorer.getCurrentWorkspace()) + "');");
        }
    }
}

