/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.io;

import java.io.IOException;
import org.jpedal.jbig2.examples.pdf.PDFSegment;

public class StreamReader {
    private byte[] data;
    private int bitPointer = 7;
    private int bytePointer = 0;

    public StreamReader(byte[] data) {
        this.data = data;
    }

    public short readByte(PDFSegment pdfSeg) {
        short bite = (short)(this.data[this.bytePointer++] & 0xFF);
        if (pdfSeg != null) {
            pdfSeg.writeToHeader(bite);
        }
        return bite;
    }

    public void readByte(short[] buf, PDFSegment pdfSeg) throws IOException {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (short)(this.data[this.bytePointer++] & 0xFF);
        }
        if (pdfSeg != null) {
            pdfSeg.writeToHeader(buf);
        }
    }

    public short readByte() {
        short bite = (short)(this.data[this.bytePointer++] & 0xFF);
        return bite;
    }

    public void readByte(short[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (short)(this.data[this.bytePointer++] & 0xFF);
        }
    }

    public int readBit() {
        short buf = this.readByte();
        short mask = (short)(1 << this.bitPointer);
        int bit = (buf & mask) >> this.bitPointer;
        --this.bitPointer;
        if (this.bitPointer == -1) {
            this.bitPointer = 7;
        } else {
            this.movePointer(-1);
        }
        return bit;
    }

    public int readBits(int num) {
        int result = 0;
        for (int i = 0; i < num; ++i) {
            result = result << 1 | this.readBit();
        }
        return result;
    }

    public void movePointer(int ammount) {
        this.bytePointer += ammount;
    }

    public void consumeRemainingBits() {
        if (this.bitPointer != 7) {
            this.readBits(this.bitPointer + 1);
        }
    }

    public boolean isFinished() {
        return this.bytePointer == this.data.length;
    }
}

