/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.ecm.webui.component.explorer.search.UIConstraintsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchContainer;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UINodeTypeSelectForm
extends UIForm
implements UIPopupComponent {
    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UINodeTypeSelectForm.label." + id);
        }
        catch (MissingResourceException ex) {
            return id + " ";
        }
    }

    public void setRenderNodeTypes() throws Exception {
        this.getChildren().clear();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List templates = templateService.getDocumentTemplates();
        for (String template : templates) {
            UICheckBoxInput uiCheckBox = new UICheckBoxInput(template, template, null);
            if (this.propertiesSelected(template)) {
                uiCheckBox.setChecked(true);
            } else {
                uiCheckBox.setChecked(false);
            }
            this.addUIFormInput((UIFormInput)uiCheckBox);
        }
    }

    private boolean propertiesSelected(String name) {
        UISearchContainer uiSearchContainer = (UISearchContainer)this.getAncestorOfType(UISearchContainer.class);
        UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)uiSearchContainer.findFirstComponentOfType(UIConstraintsForm.class);
        String typeValues = (String)uiConstraintsForm.getUIStringInput("docType").getValue();
        if (typeValues == null) {
            return false;
        }
        if (typeValues.indexOf(",") > -1) {
            String[] values;
            for (String value : values = typeValues.split(",")) {
                if (!value.equals(name)) continue;
                return true;
            }
        } else if (typeValues.equals(name)) {
            return true;
        }
        return false;
    }

    public void setNodeTypes(List<String> selectedNodeTypes) {
        StringBuffer strNodeTypes = null;
        UISearchContainer uiContainer = (UISearchContainer)this.getAncestorOfType(UISearchContainer.class);
        UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)uiContainer.findFirstComponentOfType(UIConstraintsForm.class);
        for (int i = 0; i < selectedNodeTypes.size(); ++i) {
            if (strNodeTypes == null) {
                strNodeTypes = new StringBuffer(selectedNodeTypes.get(i));
                continue;
            }
            strNodeTypes.append(",").append(selectedNodeTypes.get(i));
        }
        uiConstraintsForm.getUIStringInput("docType").setValue((Object)strNodeTypes.toString());
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UINodeTypeSelectForm> {
        public void execute(Event<UINodeTypeSelectForm> event) throws Exception {
            UISearchContainer uiSearchContainer = (UISearchContainer)((UINodeTypeSelectForm)((Object)event.getSource())).getAncestorOfType(UISearchContainer.class);
            UIPopupContainer uiPopup = (UIPopupContainer)uiSearchContainer.getChild(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchContainer);
        }
    }

    public static class SaveActionListener
    extends EventListener<UINodeTypeSelectForm> {
        public void execute(Event<UINodeTypeSelectForm> event) throws Exception {
            UINodeTypeSelectForm uiForm = (UINodeTypeSelectForm)((Object)event.getSource());
            UISearchContainer uiSearchContainer = (UISearchContainer)uiForm.getAncestorOfType(UISearchContainer.class);
            UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)uiSearchContainer.findFirstComponentOfType(UIConstraintsForm.class);
            ArrayList<String> selectedNodeTypes = new ArrayList<String>();
            ArrayList listCheckbox = new ArrayList();
            uiForm.findComponentOfType(listCheckbox, UICheckBoxInput.class);
            String nodeTypesValue = (String)uiConstraintsForm.getUIStringInput("docType").getValue();
            if (nodeTypesValue != null && nodeTypesValue.length() > 0) {
                String[] array = nodeTypesValue.split(",");
                for (int i = 0; i < array.length; ++i) {
                    selectedNodeTypes.add(array[i].trim());
                }
            }
            for (int i = 0; i < listCheckbox.size(); ++i) {
                if (((UICheckBoxInput)listCheckbox.get(i)).isChecked()) {
                    if (selectedNodeTypes.contains(((UICheckBoxInput)listCheckbox.get(i)).getName())) continue;
                    selectedNodeTypes.add(((UICheckBoxInput)listCheckbox.get(i)).getName());
                    continue;
                }
                if (selectedNodeTypes.contains(listCheckbox.get(i))) {
                    selectedNodeTypes.remove(((UICheckBoxInput)listCheckbox.get(i)).getName());
                    continue;
                }
                selectedNodeTypes.remove(((UICheckBoxInput)listCheckbox.get(i)).getName());
            }
            uiForm.setNodeTypes(selectedNodeTypes);
            uiConstraintsForm.getUICheckBoxInput("nodetypePro").setChecked(true);
            UIPopupContainer uiPopup = (UIPopupContainer)uiSearchContainer.getChild(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchContainer);
        }
    }
}

