/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.exception.DocumentEditorProviderNotFoundException;
import org.exoplatform.services.cms.documents.exception.PermissionValidationException;
import org.exoplatform.services.cms.documents.impl.EditorProvidersHelper;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.connector.collaboration.editors.DocumentEditorData;
import org.exoplatform.wcm.connector.collaboration.editors.EditorPermission;
import org.exoplatform.wcm.connector.collaboration.editors.ErrorMessage;
import org.exoplatform.wcm.connector.collaboration.editors.HypermediaLink;
import org.exoplatform.wcm.connector.collaboration.editors.PreviewInfo;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

@Path(value="/documents/editors")
public class DocumentEditorsRESTService
implements ResourceContainer {
    private static final String EXO_SYMLINK = "exo:symlink";
    private static final String PROVIDER_NOT_REGISTERED = "EditorProviderNotRegistered";
    private static final String EMPTY_REQUEST = "EmptyRequest";
    private static final String CANNOT_GET_PROVIDERS = "CannotGetProviders";
    private static final String PERMISSION_NOT_VALID = "PermissionNotValid";
    private static final String CANNOT_SAVE_PREFERRED_EDITOR = "CannotSavePreferredEditor";
    private static final String SELF = "self";
    protected static final Log LOG = ExoLogger.getLogger(DocumentEditorsRESTService.class);
    protected final DocumentService documentService;
    protected final OrganizationService organization;
    protected final SpaceService spaceService;
    protected final IdentityManager identityManager;
    protected final RepositoryService repositoryService;
    protected final LinkManager linkManager;

    public DocumentEditorsRESTService(DocumentService documentService, SpaceService spaceService, OrganizationService organizationService, IdentityManager identityManager, RepositoryService repositoryService, LinkManager linkManager) {
        this.documentService = documentService;
        this.identityManager = identityManager;
        this.organization = organizationService;
        this.spaceService = spaceService;
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    public Response getEditors(@Context UriInfo uriInfo) {
        List<DocumentEditorData> providers = this.documentService.getDocumentEditorProviders().stream().map(this::convertToDTO).collect(Collectors.toList());
        providers.forEach(provider -> this.initLinks((DocumentEditorData)provider, uriInfo));
        try {
            String json = new JsonGeneratorImpl().createJsonArray(providers).toString();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("{\"editors\":" + json + "}")).build();
        }
        catch (JsonException e) {
            LOG.error("Cannot get providers JSON, error: {}", new Object[]{e.getMessage()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage(e.getMessage(), CANNOT_GET_PROVIDERS)).build();
        }
    }

    @GET
    @Path(value="/{provider}")
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    public Response getEditor(@Context UriInfo uriInfo, @PathParam(value="provider") String provider) {
        try {
            DocumentEditorProvider editorProvider = this.documentService.getEditorProvider(provider);
            DocumentEditorData providerData = this.convertToDTO(editorProvider);
            this.initLinks(providerData, uriInfo);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)providerData).build();
        }
        catch (DocumentEditorProviderNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(e.getMessage(), PROVIDER_NOT_REGISTERED)).build();
        }
    }

    @PUT
    @Path(value="/{provider}")
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateEditor(@PathParam(value="provider") String provider, DocumentEditorData documentEditorData) {
        if (documentEditorData == null || documentEditorData.getActive() == null && documentEditorData.getPermissions() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage("The request should contain active or/and permissions fields.", EMPTY_REQUEST)).build();
        }
        try {
            DocumentEditorProvider editorProvider = this.documentService.getEditorProvider(provider);
            if (documentEditorData.getActive() != null) {
                editorProvider.updateActive(documentEditorData.getActive().booleanValue());
            }
            if (documentEditorData.getPermissions() != null) {
                List permissions = documentEditorData.getPermissions().stream().map(permission -> permission.getId()).collect(Collectors.toList());
                editorProvider.updatePermissions(permissions);
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (DocumentEditorProviderNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(e.getMessage(), PROVIDER_NOT_REGISTERED)).build();
        }
        catch (PermissionValidationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(e.getMessage(), PERMISSION_NOT_VALID)).build();
        }
    }

    @POST
    @Path(value="/preferred/{fileId}")
    @RolesAllowed(value={"users"})
    public Response preferredEditor(@PathParam(value="fileId") String fileId, @FormParam(value="userId") String userId, @FormParam(value="provider") String provider, @FormParam(value="workspace") String workspace) {
        try {
            this.documentService.savePreferredEditor(userId, provider, fileId, workspace);
        }
        catch (AccessDeniedException e) {
            LOG.error("Access denied to set preferred editor for user {} and node {}: {}", new Object[]{userId, fileId, e.getMessage()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage("Access denied error.", CANNOT_SAVE_PREFERRED_EDITOR)).build();
        }
        catch (RepositoryException e) {
            LOG.error("Cannot set preferred editor for user {} and node {}: {}", new Object[]{userId, fileId, e.getMessage()});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage(e.getMessage(), CANNOT_SAVE_PREFERRED_EDITOR)).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/preview")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response initPreview(@Context UriInfo uriInfo, @Context HttpServletRequest request, @FormParam(value="fileId") String fileId, @FormParam(value="workspace") String workspace) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        List providers = this.documentService.getDocumentEditorProviders();
        List providersInfo = EditorProvidersHelper.getInstance().initPreview(providers, identity, fileId, workspace, uriInfo.getRequestUri(), request.getLocale());
        String targetFileId = fileId;
        try {
            targetFileId = this.getTargetFileId(fileId, workspace);
        }
        catch (RepositoryException e) {
            LOG.warn("Cannot get fileId from symlink taget.", new Object[]{e.getMessage()});
        }
        PreviewInfo previewInfo = new PreviewInfo(targetFileId, providersInfo);
        return Response.ok().entity((Object)previewInfo).build();
    }

    protected String getTargetFileId(String fileId, String workspace) throws RepositoryException {
        ExtendedSession systemSession = (ExtendedSession)this.repositoryService.getCurrentRepository().getSystemSession(workspace);
        Node node = systemSession.getNodeByIdentifier(fileId);
        if (node.isNodeType(EXO_SYMLINK) && (node = this.linkManager.getTarget(node, true)) != null) {
            return node.getUUID();
        }
        return fileId;
    }

    protected void initLinks(DocumentEditorData provider, UriInfo uriInfo) {
        String path = uriInfo.getAbsolutePath().toString();
        if (!uriInfo.getPathParameters().containsKey((Object)"provider")) {
            StringBuilder pathBuilder = new StringBuilder(path);
            if (!path.endsWith("/")) {
                pathBuilder.append("/");
            }
            path = pathBuilder.append(provider.getProvider()).toString();
        }
        provider.addLink(SELF, new HypermediaLink(path.toString()));
    }

    protected DocumentEditorData convertToDTO(DocumentEditorProvider provider) {
        List<EditorPermission> permissions = provider.getPermissions().stream().map(permission -> {
            String[] temp = permission.split(":");
            if (temp.length < 2) {
                String userId = temp[0];
                org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
                if (identity != null) {
                    Profile profile = identity.getProfile();
                    String avatarUrl = profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png";
                    return new EditorPermission(userId, profile.getFullName(), avatarUrl);
                }
                return new EditorPermission(userId);
            }
            String groupId = temp[1];
            Space space = this.spaceService.getSpaceByGroupId(groupId);
            if (space != null) {
                String displayName = space.getDisplayName();
                String avatarUrl = space != null && space.getAvatarUrl() != null ? space.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
                return new EditorPermission(groupId, displayName, avatarUrl);
            }
            Group group = null;
            try {
                group = this.organization.getGroupHandler().findGroupById(groupId);
            }
            catch (Exception e) {
                LOG.error("Cannot get group by id {}. {}", new Object[]{groupId, e.getMessage()});
            }
            if (group != null) {
                String displayName = group.getLabel();
                String avatarUrl = "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
                return new EditorPermission(groupId, displayName, avatarUrl);
            }
            return new EditorPermission(groupId);
        }).collect(Collectors.toList());
        return new DocumentEditorData(provider.getProviderName(), provider.isActive(), permissions);
    }
}

