/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.voting.VotingService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/UIVoteForm.gtmpl", events={@EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIVoteForm
extends UIComponent
implements UIPopupComponent {
    public void activate() {
    }

    public void deActivate() {
    }

    public double getRating() throws Exception {
        VotingService votingService = (VotingService)WCMCoreUtils.getService(VotingService.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIDocumentInfo uiDocInfo = (UIDocumentInfo)uiExplorer.findFirstComponentOfType(UIDocumentInfo.class);
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        return votingService.getVoteValueOfUser(uiExplorer.getCurrentNode(), currentUser, uiDocInfo.getLanguage());
    }

    public String getCurrentRatingResourceKey() throws Exception {
        String voteKey = "";
        int voteValue = (int)this.getRating();
        switch (voteValue) {
            case 1: {
                voteKey = "UIVoteForm.title.normal";
                break;
            }
            case 2: {
                voteKey = "UIVoteForm.title.good";
                break;
            }
            case 3: {
                voteKey = "UIVoteForm.title.verygood";
                break;
            }
            case 4: {
                voteKey = "UIVoteForm.title.excellent";
                break;
            }
            case 5: {
                voteKey = "UIVoteForm.title.best";
                break;
            }
            default: {
                voteKey = "UIVoteForm.title.no-value";
            }
        }
        return voteKey;
    }

    public static class CancelActionListener
    extends EventListener<UIVoteForm> {
        public void execute(Event<UIVoteForm> event) throws Exception {
            ((UIPopupContainer)((UIVoteForm)((Object)event.getSource())).getAncestorOfType(UIPopupContainer.class)).cancelPopupAction();
        }
    }

    public static class VoteActionListener
    extends EventListener<UIVoteForm> {
        public void execute(Event<UIVoteForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIVoteForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            String userName = Util.getPortalRequestContext().getRemoteUser();
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)uiExplorer.findFirstComponentOfType(UIDocumentInfo.class);
            Node currentNode = uiExplorer.getCurrentNode();
            uiExplorer.addLockToken(currentNode);
            String language = uiDocumentInfo.getLanguage();
            double objId = Double.parseDouble(event.getRequestContext().getRequestParameter("objectId"));
            VotingService votingService = (VotingService)uiExplorer.getApplicationComponent(VotingService.class);
            votingService.vote(uiExplorer.getCurrentNode(), objId, userName, language);
            ((UIPopupContainer)((UIVoteForm)((Object)event.getSource())).getAncestorOfType(UIPopupContainer.class)).cancelPopupAction();
            uiExplorer.updateAjax(event);
        }
    }
}

