/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.filters;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotCloudDriveException;
import org.exoplatform.services.cms.clouddrives.NotCloudFileException;
import org.exoplatform.services.cms.clouddrives.NotYetCloudFileException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SyncingCloudFileFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(SyncingCloudFileFilter.class);

    public SyncingCloudFileFilter() {
    }

    public SyncingCloudFileFilter(List<String> providers) {
        super(providers);
    }

    protected boolean accept(Node node) throws RepositoryException {
        CloudDriveService driveService;
        CloudDrive drive;
        if (node != null && (drive = (driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class)).findDrive(node)) != null && this.acceptProvider(drive.getUser().getProvider())) {
            String path = node.getPath();
            try {
                WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                rcontext.setAttribute(CloudDrive.class, (Object)drive);
                try {
                    CloudFile file = drive.getFile(path);
                    rcontext.setAttribute(CloudFile.class, (Object)file);
                }
                catch (NotYetCloudFileException e) {
                    return true;
                }
                return false;
            }
            catch (DriveRemovedException driveRemovedException) {
            }
            catch (NotCloudFileException notCloudFileException) {
            }
            catch (NotCloudDriveException notCloudDriveException) {
                // empty catch block
            }
        }
        return false;
    }
}

