/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.pdfviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.ObjectKey;
import org.icepdf.core.pobjects.Document;

public class PDFViewerService {
    private static final Log LOG = ExoLogger.getLogger((String)PDFViewerService.class.getName());
    private static final int MAX_NAME_LENGTH = 150;
    public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
    public static final long DEFAULT_MAX_PAGES = 99L;
    public static final String MAX_FILE_SIZE_PARAM_NAME = "maxFileSize";
    public static final String MAX_PAGES_PARAM_NAME = "maxPages";
    private static final String CACHE_NAME = "ecms.PDFViewerService";
    private ExoCache<Serializable, Object> pdfCache;
    private long maxFileSize;
    private long maxPages;

    public PDFViewerService(RepositoryService repositoryService, CacheService caService, InitParams initParams) throws Exception {
        this.pdfCache = caService.getCacheInstance(CACHE_NAME);
        this.maxFileSize = 0xA00000L;
        this.maxPages = 99L;
        if (initParams != null) {
            ValueParam maxPagesValueParam;
            ValueParam maxFileSizeValueParam = initParams.getValueParam(MAX_FILE_SIZE_PARAM_NAME);
            if (maxFileSizeValueParam != null) {
                try {
                    this.maxFileSize = Long.parseLong(maxFileSizeValueParam.getValue()) * 1024L * 1024L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Parameter maxFileSize for document preview is not a valid number (" + maxFileSizeValueParam.getValue() + "), default value will be used (10485760)"));
                }
            }
            if ((maxPagesValueParam = initParams.getValueParam(MAX_PAGES_PARAM_NAME)) != null) {
                try {
                    this.maxPages = Long.parseLong(maxPagesValueParam.getValue());
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Parameter maxPages for document preview is not a valid number (" + maxPagesValueParam.getValue() + "), default value will be used (maxPages)"));
                }
            }
        }
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxPages() {
        return this.maxPages;
    }

    public ExoCache<Serializable, Object> getCache() {
        return this.pdfCache;
    }

    public Document initDocument(Node currentNode, String repoName) throws Exception {
        return this.buildDocumentImage(this.getPDFDocumentFile(currentNode, repoName), currentNode.getName());
    }

    public Document buildDocumentImage(File input, String name) {
        Document document = new Document();
        Logger.getLogger(Document.class.toString()).setLevel(Level.OFF);
        if (input == null) {
            return null;
        }
        try {
            name = this.reduceFileNameSize(name);
            FileInputStream fis = new FileInputStream(input);
            document.setInputStream((InputStream)new BufferedInputStream(fis), name);
            return document;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to build Document image from pdf file " + name));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex);
            }
            return null;
        }
    }

    public File getPDFDocumentFile(Node currentNode, String repoName) throws Exception {
        String wsName = currentNode.getSession().getWorkspace().getName();
        String uuid = currentNode.getUUID();
        StringBuilder bd = new StringBuilder();
        StringBuilder bd1 = new StringBuilder();
        StringBuilder bd2 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        bd1.append((CharSequence)bd).append("/jcr:lastModified");
        bd2.append((CharSequence)bd).append("/jcr:baseVersion");
        String path = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        String lastModifiedTime = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.toString()));
        String cachedBaseVersion = (String)this.pdfCache.get((Serializable)new ObjectKey(bd2.toString()));
        File content = null;
        String name = currentNode.getName().replaceAll(":", "_");
        Node contentNode = currentNode.getNode("jcr:content");
        String lastModified = Utils.getJcrContentLastModified(currentNode);
        String baseVersion = Utils.getJcrContentBaseVersion(currentNode);
        if (!(path != null && (content = new File(path)).exists() && lastModified.equals(lastModifiedTime) && StringUtils.equals((String)baseVersion, (String)cachedBaseVersion))) {
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            BufferedInputStream input = new BufferedInputStream(contentNode.getProperty("jcr:data").getStream());
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            name = this.reduceFileNameSize(name);
            content = File.createTempFile(name + "_tmp", ".pdf");
            String extension = DMSMimeTypeResolver.getInstance().getExtension(mimeType);
            if ("pdf".equals(extension)) {
                this.read(input, new BufferedOutputStream(new FileOutputStream(content)));
            }
            if (content.exists()) {
                if (contentNode.hasProperty("jcr:lastModified")) {
                    this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)content.getPath());
                    this.pdfCache.put((Serializable)new ObjectKey(bd1.toString()), (Object)lastModified);
                }
                this.pdfCache.put((Serializable)new ObjectKey(bd2.toString()), (Object)baseVersion);
            }
        }
        return content;
    }

    private String reduceFileNameSize(String name) {
        return name != null && name.length() > 150 ? name.substring(0, 150) : name;
    }

    private void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }
}

