/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.metadata.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class MetadataServiceImpl
implements MetadataService,
Startable {
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String INTERNAL_USE = "exo:internalUse";
    public static final String METADATA_TYPE = "exo:metadata";
    public static final String DIALOGS = "dialogs";
    public static final String VIEWS = "views";
    public static final String DIALOG1 = "dialog1";
    public static final String VIEW1 = "view1";
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String baseMetadataPath_;
    private List<TemplatePlugin> plugins_ = new ArrayList<TemplatePlugin>();
    private DMSConfiguration dmsConfiguration_;
    private static final Log LOG = ExoLogger.getLogger((String)MetadataServiceImpl.class.getName());
    private TemplateService templateService;

    public MetadataServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, DMSConfiguration dmsConfiguration) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.baseMetadataPath_ = this.nodeHierarchyCreator_.getJcrPath("metadataPath");
        this.dmsConfiguration_ = dmsConfiguration;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    public void start() {
        block2: {
            try {
                this.init();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    public void addPlugins(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    @Override
    public void init() throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            try {
                plugin.setBasePath(this.baseMetadataPath_);
                plugin.init();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    @Override
    public String addMetadata(String nodetype, boolean isDialog, String role, String content, boolean isAddNew) throws Exception {
        return this.addMetadata(nodetype, isDialog, role, content, nodetype, isAddNew);
    }

    @Override
    public String addMetadata(String nodetype, boolean isDialog, String role, String content, String label, boolean isAddNew) throws Exception {
        Session session = this.getSession();
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        String path = null;
        if (!isAddNew) {
            if (isDialog) {
                Node dialog1 = metadataHome.getNode(nodetype).getNode(DIALOGS).getNode(DIALOG1);
                path = this.templateService.updateTemplate(dialog1, new ByteArrayInputStream(content.getBytes()), role.split(";"));
                metadataHome.getNode(nodetype).setProperty("label", label);
                metadataHome.save();
            } else {
                Node view1 = metadataHome.getNode(nodetype).getNode(VIEWS).getNode(VIEW1);
                path = this.templateService.updateTemplate(view1, new ByteArrayInputStream(content.getBytes()), role.split(";"));
                metadataHome.getNode(nodetype).setProperty("label", label);
                metadataHome.save();
            }
            return path;
        }
        Node metadata = null;
        metadata = metadataHome.hasNode(nodetype) ? metadataHome.getNode(nodetype) : metadataHome.addNode(nodetype, NT_UNSTRUCTURED);
        metadata.setProperty("label", label);
        metadataHome.save();
        this.addTemplate(metadata, role, new ByteArrayInputStream(content.getBytes()), isDialog);
        metadataHome.save();
        return metadata.getPath();
    }

    private void addTemplate(Node nodetype, String role, InputStream content, boolean isDialog) throws Exception {
        Node templateHome = this.createTemplateHome(nodetype, isDialog);
        String[] arrRoles = new String[]{};
        if (role != null) {
            arrRoles = role.split(";");
        }
        if (isDialog) {
            this.templateService.createTemplate(templateHome, DIALOG1, DIALOG1, content, arrRoles);
        } else {
            this.templateService.createTemplate(templateHome, VIEW1, VIEW1, content, arrRoles);
        }
    }

    @Override
    public void removeMetadata(String nodetype) throws Exception {
        Session session = this.getSession();
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node metadata = metadataHome.getNode(nodetype);
        metadata.remove();
        metadataHome.save();
    }

    @Override
    public List<String> getMetadataList() throws Exception {
        ArrayList<String> metadataTypes = new ArrayList<String>();
        for (NodeType metadata : this.getAllMetadatasNodeType()) {
            metadataTypes.add(metadata.getName());
        }
        return metadataTypes;
    }

    @Override
    public List<NodeType> getAllMetadatasNodeType() throws Exception {
        ArrayList<NodeType> metadataTypes = new ArrayList<NodeType>();
        ExtendedNodeTypeManager ntManager = this.repositoryService_.getCurrentRepository().getNodeTypeManager();
        NodeTypeIterator ntIter = ntManager.getMixinNodeTypes();
        while (ntIter.hasNext()) {
            NodeType nt = ntIter.nextNodeType();
            if (!nt.isNodeType(METADATA_TYPE) || nt.getName().equals(METADATA_TYPE)) continue;
            metadataTypes.add(nt);
        }
        return metadataTypes;
    }

    private Node createTemplateHome(Node nodetype, boolean isDialog) throws Exception {
        if (isDialog) {
            Node dialogs = null;
            dialogs = nodetype.hasNode(DIALOGS) ? nodetype.getNode(DIALOGS) : nodetype.addNode(DIALOGS, NT_UNSTRUCTURED);
            return dialogs;
        }
        Node views = null;
        views = nodetype.hasNode(VIEWS) ? nodetype.getNode(VIEWS) : nodetype.addNode(VIEWS, NT_UNSTRUCTURED);
        return views;
    }

    @Override
    public String getMetadataTemplate(String name, boolean isDialog) throws Exception {
        Session session = this.getSession();
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node template = null;
        if (!this.hasMetadata(name)) {
            return null;
        }
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        String ret = this.templateService.getTemplate(template);
        return ret;
    }

    @Override
    public String getMetadataPath(String name, boolean isDialog) throws Exception {
        Session session = this.getSession();
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        if (!this.hasMetadata(name)) {
            return null;
        }
        Node template = null;
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        String ret = template.getPath();
        return ret;
    }

    @Override
    public String getMetadataRoles(String name, boolean isDialog) throws Exception {
        Session session = this.getSession();
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node template = null;
        if (!this.hasMetadata(name)) {
            return null;
        }
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        String ret = this.templateService.getTemplateRoles(template);
        return ret;
    }

    @Override
    public boolean hasMetadata(String name) throws Exception {
        Session session = this.getSession();
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        return metadataHome.hasNode(name);
    }

    @Override
    public List<String> getExternalMetadataType() throws Exception {
        ArrayList<String> extenalMetaTypes = new ArrayList<String>();
        block0: for (NodeType metadata : this.getAllMetadatasNodeType()) {
            for (PropertyDefinition pro : metadata.getPropertyDefinitions()) {
                if (!pro.getName().equals(INTERNAL_USE)) continue;
                if (pro.getDefaultValues()[0].getBoolean() || metadata.getName().equals(METADATA_TYPE)) continue block0;
                extenalMetaTypes.add(metadata.getName());
                continue block0;
            }
        }
        return extenalMetaTypes;
    }

    @Override
    public Node getMetadata(String metaName) throws Exception {
        Node metadataHome = (Node)this.getSession().getItem(this.baseMetadataPath_);
        try {
            return metadataHome.getNode(metaName);
        }
        catch (PathNotFoundException pne) {
            return null;
        }
    }

    @Override
    public String getMetadataLabel(String metaName) throws Exception {
        if (this.getMetadata(metaName) != null) {
            try {
                return this.getMetadata(metaName).getProperty("label").getString();
            }
            catch (PathNotFoundException pne) {
                return metaName;
            }
        }
        return null;
    }

    private Session getSession() throws Exception {
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        return WCMCoreUtils.getSystemSessionProvider().getSession(dmsRepoConfig.getSystemWorkspace(), this.repositoryService_.getCurrentRepository());
    }
}

