/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.friendly.impl;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.filter.Filter;

public class FriendlyFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FriendlyService friendlyService = WCMCoreUtils.getService(FriendlyService.class);
        if (request instanceof HttpServletRequest) {
            String uri = ((HttpServletRequest)request).getRequestURI();
            String unfriendlyUri = friendlyService.getUnfriendlyUri(uri);
            if (uri != null && !uri.equals(unfriendlyUri)) {
                String portalName = "/" + WCMCoreUtils.getPortalName();
                if (unfriendlyUri.startsWith(portalName)) {
                    unfriendlyUri = unfriendlyUri.substring(portalName.length());
                }
                ((HttpServletRequest)request).getRequestDispatcher(unfriendlyUri).forward(request, response);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

