/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import jakarta.servlet.ServletContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.skin.WCMSkinResourceResolver;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class XSkinService
implements Startable {
    static final String SEPARATOR = "/";
    static final String MODULE_NAME_PATTERN = "{repositoryName}/{portalName}";
    static final String MODULE_NAME_REGEXP = "(.*)/(.*)";
    static final String MODULE_PARAM = "moduleName";
    static final String SKIN_PARAM = "skinName";
    static final String CONTEXT_PARAM = "context";
    static final String SITENAME_PARAM = "siteName";
    public static final String SKIN_PATH_REGEXP = "/(.*)/css/jcr/(.*)/(.*)/(.*)/(.*).css";
    private static final String DEFAULT_SKIN_NAME = "Default";
    private static final String SKIN_PATH_PATTERN = "/{docBase}/css/jcr/{moduleName}/(.*)/Stylesheet-{lastModifiedDate}.css";
    private static final Log LOG = ExoLogger.getLogger((String)XSkinService.class.getName());
    private WCMConfigurationService configurationService;
    private SkinService skinService;
    private ServletContext servletContext;
    private long jsLastModifiedDate = System.currentTimeMillis();

    public XSkinService(LivePortalManagerService livePortalService) throws Exception {
        this.skinService = WCMCoreUtils.getService(SkinService.class);
        this.skinService.addResourceResolver((ResourceResolver)new WCMSkinResourceResolver(this.skinService, livePortalService));
        this.configurationService = WCMCoreUtils.getService(WCMConfigurationService.class);
        this.servletContext = WCMCoreUtils.getService(ServletContext.class);
    }

    public String getActiveStylesheet(Node webcontent) throws Exception {
        return WCMCoreUtils.getActiveStylesheet(webcontent);
    }

    public void updatePortalSkinOnModify(Node portal, Node cssFile) throws Exception {
        String sharedPortalName = this.configurationService.getSharedPortalName();
        this.jsLastModifiedDate = System.currentTimeMillis();
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal);
        } else {
            this.addPortalSkin(portal);
        }
    }

    public void updatePortalSkinOnRemove(Node portal, Node cssFile) throws Exception {
        this.updatePortalSkinOnModify(portal, cssFile);
    }

    private void addPortalSkin(Node portalNode) throws Exception {
        String moduleName = XSkinService.createModuleName(portalNode.getName());
        String skinPath = this.getSkinPath(moduleName);
        Iterator iterator = this.skinService.getAvailableSkinNames().iterator();
        if (!iterator.hasNext()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)DEFAULT_SKIN_NAME);
            this.skinService.removeSkin(moduleName, DEFAULT_SKIN_NAME);
            this.skinService.addSkin(moduleName, DEFAULT_SKIN_NAME, skinPath);
        } else {
            while (iterator.hasNext()) {
                String skinName = (String)iterator.next();
                skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
                this.skinService.removeSkin(moduleName, skinName);
                this.jsLastModifiedDate = System.currentTimeMillis();
                skinPath = this.getSkinPath(moduleName);
                skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
                this.skinService.addSkin(moduleName, skinName, skinPath);
            }
        }
    }

    private void addSharedPortalSkin(Node portalNode) throws Exception {
        String moduleName = XSkinService.createModuleName(portalNode.getName());
        String skinPath = this.getSkinPath(moduleName);
        for (String skinName : this.skinService.getAvailableSkinNames()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
            this.skinService.removePortalSkin(moduleName, skinName);
            this.skinService.addPortalSkin(moduleName, skinName, skinPath);
        }
    }

    public void start() {
        RootContainer.PortalContainerPostCreateTask task = new RootContainer.PortalContainerPostCreateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ServletContext context, PortalContainer portalContainer) {
                try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
                    LivePortalManagerService livePortalManagerService = (LivePortalManagerService)portalContainer.getComponentInstanceOfType(LivePortalManagerService.class);
                    List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
                    for (Node portal : livePortals) {
                        XSkinService.this.addPortalSkin(portal);
                    }
                    Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
                    XSkinService.this.addSharedPortalSkin(sharedPortal);
                }
            }
        };
        PortalContainer.addInitTask((ServletContext)this.servletContext, (RootContainer.PortalContainerInitTask)task, null);
    }

    public void stop() {
    }

    static String createModuleName(String siteName) {
        String repoName;
        try {
            repoName = WCMCoreUtils.getRepository().getConfiguration().getName();
        }
        catch (NullPointerException e) {
            repoName = WCMCoreUtils.getService(RepositoryService.class).getConfig().getDefaultRepositoryName();
        }
        String moduleName = StringUtils.replaceOnce((String)MODULE_NAME_PATTERN, (String)"{repositoryName}", (String)repoName);
        moduleName = StringUtils.replaceOnce((String)moduleName, (String)"{portalName}", (String)siteName);
        return moduleName;
    }

    static Map<String, String> getSkinParams(String path) {
        String skinName;
        String siteName;
        String context;
        if (!path.matches(SKIN_PATH_REGEXP)) {
            return null;
        }
        String[] elements = path.split(SEPARATOR);
        if (SEPARATOR.equals(SEPARATOR)) {
            context = elements[4];
            siteName = elements[5];
            skinName = elements[6];
        } else {
            context = elements[4].split(SEPARATOR)[0];
            siteName = elements[4].split(SEPARATOR)[1];
            skinName = elements[5];
        }
        String moduleName = StringUtils.replaceOnce((String)MODULE_NAME_PATTERN, (String)"{repositoryName}", (String)context);
        moduleName = StringUtils.replaceOnce((String)moduleName, (String)"{portalName}", (String)siteName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(MODULE_PARAM, moduleName);
        params.put(SKIN_PARAM, skinName);
        params.put(SITENAME_PARAM, siteName);
        params.put(CONTEXT_PARAM, context);
        return params;
    }

    private String getSkinPath(String moduleName) {
        return StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"{moduleName}", (String)moduleName).replaceFirst("\\{lastModifiedDate\\}", String.valueOf(this.jsLastModifiedDate)).replaceFirst("\\{docBase\\}", this.servletContext.getServletContextName());
    }
}

