/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectDocumentForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/UISelectDocumentTemplateTitle.gtmpl", events={@EventConfig(listeners={ChangeViewActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UISelectDocumentTemplateTitle
extends UIComponent {
    private static final String THUMBNAIL_VIEW_TEMPLATE = "app:/groovy/webui/component/explorer/UISelectDocumentFormThumbnailView.gtmpl";
    private static final String LIST_VIEW_TEMPLATE = "app:/groovy/webui/component/explorer/UISelectDocumentFormListView.gtmpl";

    public static class CancelActionListener
    extends EventListener<UISelectDocumentTemplateTitle> {
        public void execute(Event<UISelectDocumentTemplateTitle> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UISelectDocumentTemplateTitle)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            if (uiExplorer != null) {
                UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
                UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
                if (uiDocumentWorkspace.getChild(UIDocumentFormController.class) != null) {
                    uiDocumentWorkspace.removeChild(UIDocumentFormController.class);
                } else {
                    uiExplorer.cancelAction();
                }
                uiExplorer.updateAjax(event);
            }
        }
    }

    public static class ChangeViewActionListener
    extends EventListener<UISelectDocumentTemplateTitle> {
        private static final String THUMBNAIL_VIEW_TYPE = "ThumbnailView";

        public void execute(Event<UISelectDocumentTemplateTitle> event) throws Exception {
            String viewType = event.getRequestContext().getRequestParameter("objectId");
            UISelectDocumentTemplateTitle uiTemplateTitle = (UISelectDocumentTemplateTitle)((Object)event.getSource());
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiTemplateTitle.getAncestorOfType(UIWorkingArea.class);
            UISelectDocumentForm uiSelectForm = (UISelectDocumentForm)((UIDocumentFormController)((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).getChild(UIDocumentFormController.class)).getChild(UISelectDocumentForm.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSelectForm.getAncestorOfType(UIJCRExplorer.class);
            if (viewType.equals(THUMBNAIL_VIEW_TYPE)) {
                uiSelectForm.setTemplate(UISelectDocumentTemplateTitle.THUMBNAIL_VIEW_TEMPLATE);
            } else {
                uiSelectForm.setTemplate(UISelectDocumentTemplateTitle.LIST_VIEW_TEMPLATE);
            }
            uiExplorer.updateAjax(event);
        }
    }
}

