/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import javax.jcr.Node;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class FileRemovePropertyActivityListener
extends Listener<Node, String> {
    private String[] removedField = new String[]{"exo:title", "dc:title", "dc:description", "dc:creator", "dc:source"};
    private String[] bundleMessage = new String[]{"SocialIntegration.messages.removeName", "SocialIntegration.messages.removeTitle", "SocialIntegration.messages.removeDescription", "SocialIntegration.messages.removeCreator", "SocialIntegration.messages.removeSource"};
    private boolean[] needUpdate = new boolean[]{true, true, false, false, false};
    private int consideredFieldCount = this.removedField.length;
    private static final String REMOVE_PROPERTY = "files:spaces.REMOVE_PROPERTY";

    public void onEvent(Event<Node, String> event) throws Exception {
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        if (!activityManager.isActivityTypeEnabled(REMOVE_PROPERTY)) {
            return;
        }
        Node currentNode = (Node)event.getSource();
        String propertyName = (String)event.getData();
        if (currentNode.isNodeType("nt:resource")) {
            currentNode = currentNode.getParent();
        }
        String resourceBundle = "";
        for (int i = 0; i < this.consideredFieldCount; ++i) {
            if (!propertyName.equals(this.removedField[i])) continue;
            resourceBundle = this.bundleMessage[i];
            Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, "", "");
            break;
        }
    }
}

