/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/documents")
@Tag(name="/documents", description="Managing documents")
public class DocumentRestService
implements ResourceContainer {
    private DocumentService documentService;
    private static final int DEFAULT_LIMIT = 20;

    public DocumentRestService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @GET
    @Path(value="/favorite")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets favorite documents", method="GET", description="This returns favorite documents")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getFavoriteDocuments(@Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (limit <= 0) {
            limit = 20;
        }
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok(this.documentService.getFavoriteDocuments(userId, limit)).build();
    }

    @GET
    @Path(value="/folder")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets documents by folder", method="GET", description="This returns documents by folder")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getDocumentsByFolder(@Parameter(description="Folder from which documents to be retrieved", required=true) @QueryParam(value="folder") String folder, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (folder == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (limit <= 0) {
            limit = 20;
        }
        return Response.ok(this.documentService.getDocumentsByFolder(folder, null, limit)).build();
    }

    @GET
    @Path(value="/query")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets documents by quey", method="GET", description="This returns documents by quey")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getDocumentsByQuery(@Parameter(description="Query from which documents to be retrieved", required=true) @QueryParam(value="query") String query, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (query == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (limit <= 0) {
            limit = 20;
        }
        return Response.ok(this.documentService.getDocumentsByQuery(query, limit)).build();
    }

    @GET
    @Path(value="/shared")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets shared documents", method="GET", description="This returns shared documents")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getSharedDocuments(@Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (limit <= 0) {
            limit = 20;
        }
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok(this.documentService.getSharedDocuments(userId, limit)).build();
    }
}

