/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.connector.fckeditor.FCKMessage;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.JSONValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUploadHandler {
    private static final Log LOG = ExoLogger.getLogger((String)FileUploadHandler.class.getName());
    public static final String UPLOAD_ACTION = "upload";
    public static final String PROGRESS_ACTION = "progress";
    public static final String ABORT_ACTION = "abort";
    public static final String DELETE_ACTION = "delete";
    public static final String SAVE_ACTION = "save";
    public static final String SAVE_NEW_VERSION_ACTION = "saveNewVersion";
    public static final String CHECK_EXIST = "exist";
    public static final String REPLACE = "replace";
    public static final String CREATE_VERSION = "createVersion";
    public static final String KEEP_BOTH = "keepBoth";
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    public static final String UPLOAD_DOC_NEW_APP = "exo.upload.doc.newApp";
    public static final String UPLOAD_DOC_OLD_APP = "exo.upload.doc.oldApp";
    private static final String OLD_APP = "oldApp";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String POST_CREATE_CONTENT_EVENT = "CmsService.event.postCreate";
    private final String CONNECTOR_BUNDLE_LOCATION = "locale.wcm.resources.WCMResourceBundleConnector";
    private final String AUTOVERSION_ERROR_MIME_TYPE = "DocumentAutoVersion.msg.WrongMimeType";
    private static final String FILE_DECODE_REGEX = "%(?![0-9a-fA-F]{2})";
    private DocumentService documentService;
    private RepositoryService repositoryService;
    private UploadService uploadService = (UploadService)WCMCoreUtils.getService(UploadService.class);
    ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
    private ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
    private FCKMessage fckMessage;
    private Map<String, Long> uploadIdTimeMap;
    private long UPLOAD_LIFE_TIME;

    public FileUploadHandler() {
        this.documentService = (DocumentService)WCMCoreUtils.getService(DocumentService.class);
        this.repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        this.fckMessage = new FCKMessage();
        this.uploadIdTimeMap = new Hashtable<String, Long>();
        this.UPLOAD_LIFE_TIME = System.getProperty("MULTI_UPLOAD_LIFE_TIME") == null ? 600L : Long.parseLong(System.getProperty("MULTI_UPLOAD_LIFE_TIME"));
    }

    public Response upload(HttpServletRequest servletRequest, String uploadId, Integer limit) throws Exception {
        this.uploadService.addUploadLimit(uploadId, limit);
        this.uploadService.createUploadResource(servletRequest);
        this.uploadIdTimeMap.put(uploadId, System.currentTimeMillis());
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("html");
        Element head = doc.createElement("head");
        Element body = doc.createElement("body");
        rootElement.appendChild(head);
        rootElement.appendChild(body);
        doc.appendChild(rootElement);
        return Response.ok((Object)new DOMSource(doc), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response checkStatus(String uploadId, String language) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (StringUtils.isEmpty((String)uploadId) || this.uploadService.getUploadResource(uploadId) == null) {
            return null;
        }
        if (2 == this.uploadService.getUploadResource(uploadId).getStatus()) {
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            String uploadLimit = String.valueOf(((UploadService.UploadLimit)this.uploadService.getUploadLimits().get(uploadId)).getLimit());
            Document fileExceedLimit = this.fckMessage.createMessage(205, "Error", language, new String[]{uploadLimit});
            return Response.ok((Object)new DOMSource(fileExceedLimit), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        return null;
    }

    public Response control(String uploadId, String action) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (PROGRESS_ACTION.equals(action)) {
            Document currentProgress = this.getProgress(uploadId);
            return Response.ok((Object)new DOMSource(currentProgress), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (ABORT_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (DELETE_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        return Response.status((int)400).cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response checkExistence(Node parent, String fileName) throws Exception {
        Node existNode;
        DMSMimeTypeResolver resolver = DMSMimeTypeResolver.getInstance();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document fileExistence = builder.newDocument();
        fileName = Utils.cleanNameWithAccents((String)fileName);
        fileName = fileName.replaceAll(FILE_DECODE_REGEX, "%25");
        fileName = URLDecoder.decode(fileName, "UTF-8");
        fileName = fileName.replaceAll(FILE_DECODE_REGEX, "-");
        Element rootElement = fileExistence.createElement(parent.hasNode(fileName) ? "Existed" : "NotExisted");
        if (parent.hasNode(fileName) && (existNode = parent.getNode(fileName)).isNodeType("mix:versionable")) {
            rootElement.appendChild(fileExistence.createElement("Versioned"));
        }
        if (parent.isNodeType("nt:file") && resolver.getMimeType(parent.getName()).equals(resolver.getMimeType(fileName))) {
            rootElement.appendChild(fileExistence.createElement("CanVersioning"));
        }
        fileExistence.appendChild(rootElement);
        return Response.ok((Object)new DOMSource(fileExistence), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response cleanName(String fileName) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document cleanedFilename = builder.newDocument();
        fileName = Utils.cleanNameWithAccents((String)fileName);
        Element rootElement = cleanedFilename.createElement("name");
        cleanedFilename.appendChild(rootElement);
        rootElement.setTextContent(fileName);
        return Response.ok((Object)new DOMSource(cleanedFilename), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response saveAsNTFile(String workspaceName, Node parent, String uploadId, String fileName, String language, String source, String siteName, String userId) throws Exception {
        return this.saveAsNTFile(workspaceName, parent, uploadId, fileName, language, source, siteName, userId, KEEP_BOTH);
    }

    public Response saveAsNTFile(String workspaceName, Node parent, String uploadId, String fileName, String language, String source, String siteName, String userId, String existenceAction) throws Exception {
        return this.saveAsNTFile(workspaceName, parent, uploadId, fileName, language, source, siteName, userId, existenceAction, false);
    }

    public synchronized Response saveAsNTFile(String workspaceName, Node parent, String uploadId, String fileName, String language, String source, String siteName, String userId, String existenceAction, boolean isNewVersion) throws Exception {
        String exoTitle = Utils.normalizeFileBaseName((String)fileName);
        fileName = Utils.cleanNameWithAccents((String)fileName);
        fileName = Text.escapeIllegalJcrChars((String)Utils.cleanName((String)fileName.toLowerCase()));
        try {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            UploadResource resource = this.uploadService.getUploadResource(uploadId);
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
            if (parent == null) {
                Document fileNotUploaded = this.fckMessage.createMessage(204, "Error", language, null);
                return Response.ok((Object)new DOMSource(fileNotUploaded), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            if (!FCKUtils.hasAddNodePermission(parent)) {
                Object[] args = new Object[]{parent.getPath()};
                Document message = this.fckMessage.createMessage(203, "Error", language, args);
                return Response.ok((Object)new DOMSource(message), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            if (fileName == null || fileName.length() == 0) {
                fileName = resource.getFileName();
            }
            if (parent.isLocked()) {
                parent.getSession().addLockToken(LockUtil.getLockToken((Node)parent));
            }
            if (parent.hasNode(fileName) && REPLACE.equals(existenceAction)) {
                ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, (Object)parent, (Object)parent.getNode(fileName));
                parent.getNode(fileName).remove();
                parent.save();
            }
            AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
            String location = resource.getStoreLocation();
            Node file = null;
            Node jcrContent = null;
            boolean fileCreated = false;
            DMSMimeTypeResolver mimeTypeResolver = DMSMimeTypeResolver.getInstance();
            String mimetype = mimeTypeResolver.getMimeType(resource.getFileName());
            String nodeName = fileName;
            int count = 0;
            if (!CREATE_VERSION.equals(existenceAction) || !parent.hasNode(fileName) && !CREATE_VERSION.equals(existenceAction)) {
                if (parent.isNodeType("nt:file")) {
                    String mimeTypeParent = mimeTypeResolver.getMimeType(parent.getName());
                    if (mimetype != mimeTypeParent) {
                        ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
                        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.wcm.resources.WCMResourceBundleConnector", new Locale(language));
                        String errorMsg = resourceBundle.getString("DocumentAutoVersion.msg.WrongMimeType");
                        errorMsg = errorMsg.replace("{0}", StringUtils.escape((String)("<span style='font-weight:bold;'>" + parent.getName() + "</span>")));
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("error_type", (Object)"ERROR_MIMETYPE");
                        jsonObject.put("error_message", (Object)errorMsg);
                        return Response.serverError().entity((Object)jsonObject.toString()).build();
                    }
                    parent = parent.getParent();
                }
                boolean doIndexName = parent.hasNode(nodeName);
                do {
                    try {
                        file = parent.addNode(nodeName, "nt:file");
                        fileCreated = true;
                    }
                    catch (ItemExistsException e) {
                        nodeName = this.increaseName(fileName, ++count);
                        doIndexName = false;
                    }
                } while (!fileCreated);
                if (exoTitle != null && count >= 1) {
                    exoTitle = FileUploadHandler.getNewName(exoTitle, "(" + count + ")");
                }
                if (!file.isNodeType("mix:referenceable")) {
                    file.addMixin("mix:referenceable");
                }
                if (!file.isNodeType("mix:commentable")) {
                    file.addMixin("mix:commentable");
                }
                if (!file.isNodeType("mix:votable")) {
                    file.addMixin("mix:votable");
                }
                if (!file.isNodeType("mix:i18n")) {
                    file.addMixin("mix:i18n");
                }
                if (!file.hasProperty("exo:title") && doIndexName) {
                    String name = file.getName();
                    String path = file.getPath();
                    String index = path.substring(StringUtils.indexOf((String)path, (String)name) + name.length());
                    if (exoTitle != null && StringUtils.isNotBlank((String)index)) {
                        int indexSuffix = Integer.parseInt(index.substring(1, index.lastIndexOf("]")));
                        String suffix = "(" + (indexSuffix - 1) + ")";
                        exoTitle = FileUploadHandler.getNewName(exoTitle, suffix);
                    }
                    file.setProperty("exo:title", Utils.cleanDocumentTitle((String)exoTitle));
                } else if (!file.hasProperty("exo:title")) {
                    file.setProperty("exo:title", Utils.cleanDocumentTitle((String)exoTitle));
                }
                jcrContent = file.addNode("jcr:content", "nt:resource");
            } else if (parent.hasNode(nodeName)) {
                file = parent.getNode(nodeName);
                jcrContent = file.hasNode("jcr:content") ? file.getNode("jcr:content") : file.addNode("jcr:content", "nt:resource");
            } else if (parent.isNodeType("nt:file")) {
                file = parent;
                autoVersionService.autoVersion(file, isNewVersion);
                jcrContent = file.hasNode("jcr:content") ? file.getNode("jcr:content") : file.addNode("jcr:content", "nt:resource");
            }
            jcrContent.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            jcrContent.setProperty("jcr:data", (InputStream)new BufferedInputStream(new FileInputStream(new File(location))));
            jcrContent.setProperty("jcr:mimeType", mimetype);
            file.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
            if (parent.hasNode(nodeName) && CREATE_VERSION.equals(existenceAction)) {
                file.save();
                autoVersionService.autoVersion(file, isNewVersion);
            }
            if (fileCreated) {
                file.getParent().save();
                autoVersionService.autoVersion(file, isNewVersion);
                if (file.isNodeType("mix:versionable")) {
                    if (!file.isCheckedOut()) {
                        file.checkout();
                    }
                    file.checkin();
                    file.checkout();
                }
            }
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
            wcmPublicationService.updateLifecyleOnChangeContent(file, siteName, userId);
            if (this.activityService.isBroadcastNTFileEvents(file) && !CREATE_VERSION.equals(existenceAction)) {
                this.listenerService.broadcast(ActivityCommonService.FILE_CREATED_ACTIVITY, null, (Object)file);
            }
            file.save();
            Document doc = this.getUploadedFile(workspaceName, file, mimetype);
            String eventName = source.equals(OLD_APP) ? UPLOAD_DOC_OLD_APP : UPLOAD_DOC_NEW_APP;
            try {
                this.listenerService.broadcast(eventName, (Object)userId, (Object)file);
            }
            catch (Exception e) {
                LOG.error((Object)"Error broadcast upload document event", (Throwable)e);
            }
            return Response.ok((Object)new DOMSource(doc), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    private static String getNewName(String exoTitle, String newNameSuffix) {
        int pointIndex = exoTitle.lastIndexOf(".");
        String extension = pointIndex != -1 ? exoTitle.substring(pointIndex) : "";
        exoTitle = pointIndex != -1 ? exoTitle.substring(0, pointIndex).concat(newNameSuffix).concat(extension) : exoTitle.concat(newNameSuffix);
        return exoTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getUploadedFile(String workspaceName, Node file, String mimetype) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("file");
        LinkedHashMap previewBreadcrumb = new LinkedHashMap();
        ExtendedSession session = null;
        try {
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node node = session.getNodeByIdentifier(file.getUUID());
            previewBreadcrumb = this.documentService.getFilePreviewBreadCrumb(node);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting file node " + file.getUUID()), (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        String downloadUrl = this.getDownloadUrl(workspaceName, file.getPath());
        String url = this.getUrl(file.getPath());
        String lastEditor = this.getStringProperty(file, "exo:lastModifier");
        String date = this.getStringProperty(file, "exo:dateModified");
        rootElement.setAttribute("UUID", file.getUUID());
        rootElement.setAttribute("title", file.getName());
        rootElement.setAttribute("path", file.getPath());
        rootElement.setAttribute("mimetype", mimetype);
        rootElement.setAttribute("previewBreadcrumb", JSONValue.toJSONString((Object)previewBreadcrumb));
        rootElement.setAttribute("downloadUrl", downloadUrl);
        rootElement.setAttribute("url", url);
        rootElement.setAttribute("lastEditor", lastEditor);
        rootElement.setAttribute("date", date);
        List permissions = ((NodeImpl)file).getACL().getPermissionEntries();
        rootElement.setAttribute("acl", JSONValue.toJSONString((Object)this.getFileACL(permissions)));
        long size = file.getNode("jcr:content").getProperty("jcr:data").getLength();
        rootElement.setAttribute("size", String.valueOf(size));
        doc.appendChild(rootElement);
        return doc;
    }

    private JSONObject getFileACL(List<AccessControlEntry> permissions) throws JSONException {
        Boolean canRead = permissions.stream().anyMatch(perm -> perm.getPermission().equals("read"));
        Boolean canEdit = permissions.stream().anyMatch(perm -> perm.getPermission().equals("set_property"));
        Boolean canRemove = permissions.stream().anyMatch(perm -> perm.getPermission().equals("remove"));
        JSONObject acl = new JSONObject();
        acl.put("canEdit", (Object)canEdit);
        acl.put("canRead", (Object)canRead);
        acl.put("canRemove", (Object)canRemove);
        return acl;
    }

    private String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    protected String getUrl(String nodePath) {
        String url = "";
        try {
            url = this.documentService.getLinkInDocumentsApp(nodePath);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get url of document " + nodePath), (Throwable)e);
        }
        return url;
    }

    private String getDownloadUrl(String workspace, String nodePath) {
        String restContextName = WCMCoreUtils.getRestContextName();
        String repositoryName = this.getRepositoryName();
        StringBuffer downloadUrl = new StringBuffer();
        downloadUrl.append('/').append(restContextName).append("/jcr/").append(repositoryName).append('/').append(workspace).append(nodePath);
        return downloadUrl.toString();
    }

    protected String getRepositoryName() {
        try {
            return this.repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            LOG.debug((Object)"Cannot get repository name", (Throwable)e);
            return "repository";
        }
    }

    public boolean isDocumentNodeType(Node node) throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        return templateService.isManagedNodeType(node.getPrimaryNodeType().getName());
    }

    private String increaseName(String origin, int count) {
        int index = origin.indexOf(46);
        if (index == -1) {
            return origin + count;
        }
        return origin.substring(0, index) + count + origin.substring(index);
    }

    public long getUploadingFileCount() {
        this.removeDeadUploads();
        return this.uploadIdTimeMap.size();
    }

    private void removeDeadUploads() {
        HashSet<String> removedIds = new HashSet<String>();
        for (String id : this.uploadIdTimeMap.keySet()) {
            if (System.currentTimeMillis() - this.uploadIdTimeMap.get(id) <= this.UPLOAD_LIFE_TIME * 1000L) continue;
            removedIds.add(id);
        }
        for (String id : removedIds) {
            this.uploadIdTimeMap.remove(id);
        }
    }

    private Document getProgress(String uploadId) throws Exception {
        UploadResource resource = this.uploadService.getUploadResource(uploadId);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Double percent = 0.0;
        if (resource != null) {
            percent = resource.getStatus() == 0 ? Double.valueOf(resource.getUploadedSize() * 100.0 / resource.getEstimatedSize()) : Double.valueOf(100.0);
        }
        Element rootElement = doc.createElement("UploadProgress");
        rootElement.setAttribute("uploadId", uploadId);
        rootElement.setAttribute("fileName", resource == null ? "" : resource.getFileName());
        rootElement.setAttribute("percent", "" + percent.intValue());
        rootElement.setAttribute("uploadedSize", (String)(resource == null ? "0" : "" + resource.getUploadedSize()));
        rootElement.setAttribute("totalSize", (String)(resource == null ? "0" : "" + resource.getEstimatedSize()));
        rootElement.setAttribute("fileType", (String)(resource == null ? "null" : resource.getMimeType()));
        UploadService.UploadLimit limit = (UploadService.UploadLimit)this.uploadService.getUploadLimits().get(uploadId);
        if (limit != null) {
            rootElement.setAttribute("limit", "" + limit.getLimit());
            rootElement.setAttribute("unit", limit.getUnit());
        }
        doc.appendChild(rootElement);
        return doc;
    }

    private DOMSource createDOMResponse(String name, String mimeType) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement(name);
        rootElement.setAttribute("mimetype", mimeType);
        doc.appendChild(rootElement);
        return new DOMSource(doc);
    }
}

