/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.i18n.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.deployment.plugins.TranslationDeploymentDescriptor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class AddTranslationPlugin
extends CreatePortalPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)AddTranslationPlugin.class.getName());
    private static final Pattern FILE_EXPLORER_URL_SYNTAX = Pattern.compile("([^:/]+):(/.*)");
    private InitParams initParams;
    private MultiLanguageService languageService;

    public AddTranslationPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, MultiLanguageService languageService) {
        super(initParams, configurationManager, repositoryService);
        this.initParams = initParams;
        this.languageService = languageService;
    }

    @Override
    public void deployToPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        TranslationDeploymentDescriptor translationDescriptor = null;
        while (iterator.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)iterator.next();
            translationDescriptor = (TranslationDeploymentDescriptor)objectParameter.getObject();
            List<String> translationPaths = translationDescriptor.getTranslationNodePaths();
            boolean isOverrideExistence = translationDescriptor.isOverrideExistence();
            ArrayList<String> translationRealPaths = new ArrayList<String>();
            if (portalName != null && portalName.length() > 0) {
                for (String path : translationPaths) {
                    translationRealPaths.add(StringUtils.replace((String)path, (String)"{portalName}", (String)portalName));
                }
            }
            int numOfTrans = translationRealPaths.size();
            for (int i = 0; i < numOfTrans; ++i) {
                Node currNode = this.getNodeByPath((String)translationRealPaths.get(i));
                if (currNode == null) continue;
                for (int j = i + 1; j < numOfTrans; ++j) {
                    Node targetTranslationNode = this.getNodeByPath((String)translationRealPaths.get(j));
                    if (targetTranslationNode == null) continue;
                    try {
                        this.languageService.addLinkedLanguage(currNode, targetTranslationNode, isOverrideExistence);
                        this.languageService.addLinkedLanguage(targetTranslationNode, currNode, isOverrideExistence);
                        continue;
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)("Add translation " + (String)translationRealPaths.get(j) + " for " + (String)translationRealPaths.get(i) + " FAILED at " + new Date().toString() + "\n"), (Throwable)e);
                    }
                }
            }
        }
    }

    private Node getNodeByPath(String nodePath) throws RepositoryException {
        try {
            Matcher matcher = FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
            if (!matcher.find()) {
                return null;
            }
            String wsName = matcher.group(1);
            nodePath = matcher.group(2);
            Session session = WCMCoreUtils.getSystemSessionProvider().getSession(wsName, WCMCoreUtils.getRepository());
            return (Node)session.getItem(nodePath);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (NoSuchWorkspaceException e) {
            return null;
        }
    }
}

